% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeCompustat.R
\name{mergeCompustat}
\alias{mergeCompustat}
\title{Connect sentiment count of multiple cik's 10-K filing with Compustat data.}
\usage{
mergeCompustat (cik.no, filing.yr, words.list, compustat.data)
}
\arguments{
\item{cik.no}{cik number.}

\item{filing.yr}{10-K filing year.}

\item{words.list}{sentiment dictionary in list format.}

\item{compustat.data}{Compustat dataframe.}
}
\value{
Compustat data with sentiment.count column for desired cik and filing year.
}
\description{
\code{mergeCompustat} merge sentiment count of 10-K filing with Compustat data.
}
\details{
mergeCompustat function takes cik number, filing year, sentiment dictionary, and  
Compustat data. It downloads 10-K filings for desired cik and filing year  
present in an input Compustat dataset in new directory "Edgar filings/Compustat filings".
The function also counts sentiment words from 10-K's and append those counts with new 
column named "sentiment.count" to Compustat dataframe. Working directory must contain 
'Master Index' directory which contains master Rda files for specified filing year. 
This master index can be downloaded using \link[edgar]{getMasterIndex} function. 
Please note that Compustat data must contains 'cik' column, and  'datadate' 
column in 'mm/dd/yyyy' format.
}
\examples{
\dontrun{

## User needs to input Compustat data in dataframe format.
compustat.data <- read.csv('compustat_data.csv')

## User can apply any desired user defined dictionary 
## other than default dictionaries from this package.
words.list <- scan(system.file('data/negwords.txt', package = 'edgar') 
                   , what='character')

## For single cik
res <- mergeCompustat( 2098, 2014, words.list, compustat.data)

## User can provide list of different CIK's.
cik.no <- c(1750,6201,2098)
res <- mergeCompustat( cik.no, 2014, words.list, compustat.data)
 
}

}
