
<!-- README.md is generated from README.Rmd. Please edit that file -->

# edbuild

<!-- badges: start -->

<!-- badges: end -->

The goal of `edbuildr` is to allow to import EdBuild’s master dataset of
school district finance, student demographics, and community economic
indicators for every school district in the United States.  
The master dataset is built from the US Census, Annual Survey of School
System Finances (F33) and joins data from the National Center for
Education Statistics, Common Core of Data (CCD); the US Census, Small
Area Income and Poverty Estimates (SAIPE); and the US Census, Education
Demographic and Geographic Estimates (EDGE). We apply EdBuild’s standard
processing to the dataset and provide the option to select from four
different exclusion criteria - see the masterpull help file for full
details. The master dataset is available for any school year 2013-2017
or longitudinally for 2013-2017. Additional functions in the package use
EdBuild’s master data to analyze the difference between neighboring
school districts and create formatted excel tables of school district
data.

## Installation

You can install the released version of edbuild from
[CRAN](https://CRAN.R-project.org) with:

``` r
install.packages("edbuildr")
```

## Example

To view school district finance data for all districts:

``` r
library(edbuildr)
## To import EdBuild's master dataset of school district finance, student demographic, and community economic data for 2017:
master_17 <- masterpull(data_year = "2017")

str(master_17)
#> 'data.frame':    13184 obs. of  40 variables:
#>  $ NCESID              : int  100240 100270 100300 101410 100360 100420 102550 100480 100510 100090 ...
#>  $ State               : chr  "Alabama" "Alabama" "Alabama" "Alabama" ...
#>  $ STATE_FIPS          : int  1 1 1 1 1 1 1 1 1 1 ...
#>  $ NAME                : chr  "Autauga County School District" "Baldwin County School District" "Barbour County School District" "Eufaula City School District" ...
#>  $ CONUM               : int  1001 1003 1005 1005 1007 1009 1009 1011 1013 1015 ...
#>  $ ENROLL              : int  9307 31268 847 3949 3291 7793 1492 1476 3131 2069 ...
#>  $ LRPP                : num  2012 5742 3221 1677 2004 ...
#>  $ SRPP                : num  5796 4823 6566 4401 6704 ...
#>  $ SLRPP               : num  7809 10564 9786 6077 8708 ...
#>  $ LR                  : num  1.87e+07 1.80e+08 2.73e+06 6.62e+06 6.60e+06 ...
#>  $ SR                  : num  5.39e+07 1.51e+08 5.56e+06 1.74e+07 2.21e+07 ...
#>  $ SLR                 : num  7.27e+07 3.30e+08 8.29e+06 2.40e+07 2.87e+07 ...
#>  $ SRPP_cola           : num  6095 5066 7336 4917 7458 ...
#>  $ LRPP_cola           : num  2116 6031 3599 1873 2229 ...
#>  $ SLRPP_cola          : num  8211 11097 10934 6790 9687 ...
#>  $ County              : chr  "Autauga County" "Baldwin County" "Barbour County" "Barbour County" ...
#>  $ dType               : chr  "1-Regular local school district that is NOT a component of a supervisory union" "1-Regular local school district that is NOT a component of a supervisory union" "1-Regular local school district that is NOT a component of a supervisory union" "1-Regular local school district that is NOT a component of a supervisory union" ...
#>  $ dUrbanicity         : chr  "41-Rural: Fringe" "41-Rural: Fringe" "43-Rural: Remote" "41-Rural: Fringe" ...
#>  $ dOperational_schools: int  15 45 3 5 9 17 3 4 7 7 ...
#>  $ dEnroll_district    : int  9307 31268 847 3949 3291 7793 1492 1476 3131 2069 ...
#>  $ dFRL                : int  4461 14071 630 2908 2150 4312 638 NA 2460 1411 ...
#>  $ FRL_rate            : num  0.479 0.45 0.744 0.736 0.653 ...
#>  $ dLEP                : int  104 927 63 88 46 313 87 112 14 19 ...
#>  $ dIEP                : int  653 2749 56 204 325 666 91 96 215 180 ...
#>  $ dWhite              : int  6261 22950 51 1792 2431 6449 997 18 1063 96 ...
#>  $ dBlack              : int  2319 3941 689 1812 728 102 64 1242 1969 1867 ...
#>  $ dHispanic           : int  261 2577 101 272 92 1155 347 213 34 75 ...
#>  $ dAsian_PI           : int  233 309 NA 36 7 12 11 3 19 4 ...
#>  $ dHawaiian_PI        : int  10 23 NA 7 NA 2 1 NA 2 NA ...
#>  $ dAmIndian_Aknative  : int  26 116 3 8 4 32 4 NA 7 NA ...
#>  $ d2plus_races        : int  197 1352 3 22 29 41 68 NA 37 27 ...
#>  $ pctNonwhite         : num  0.327 0.266 0.94 0.546 0.261 ...
#>  $ TPop                : int  55504 212628 13182 12088 22668 51356 6657 10309 19825 22350 ...
#>  $ StPop               : int  9990 34538 1686 2257 3340 9052 1028 1512 3341 3184 ...
#>  $ StPov               : int  1842 4871 726 1178 870 1573 190 732 1049 1106 ...
#>  $ StPovRate           : num  0.184 0.141 0.431 0.522 0.26 ...
#>  $ MPV                 : int  143000 182000 70400 120600 105500 120800 151400 66800 88800 95700 ...
#>  $ MHI                 : int  55317 52562 33318 33444 43404 47167 49267 29655 36326 32070 ...
#>  $ sd_area             : num  604.4 1609.9 831 73.5 626.2 ...
#>  $ student_per_sq_mile : num  15.4 19.42 1.02 53.73 5.26 ...
```

## Authors

  - Megan Brodzik (<megan@edbuild.org>), maintainer
  - Cecilia Depman (<cecilia@edbuild.org>), author
  - Sara Hodges (<sara@edbuild.org>), author
  - Kailey Spencer (<kailey.spencer.depoe@gmail.com>), contributor
