
<!-- README.md is generated from README.Rmd. Please edit that file -->

# edbuildmapr

<!-- badges: start -->

<!-- badges: end -->

The goal of `edbuildmapr` is to simplify the use of school district
shapefiles. The package import US Census Bureau, Education Demographic
and Geographic Estimates Program, Composite School District Boundaries
Files for 2013-2019 with the option to attach EdBuild’s master dataset
of school district finance, student demographics, and community economic
indicators for every school district in the United States. The master
dataset is built from the US Census, Annual Survey of School System
Finances (F33) and joins data from the National Center for Education
Statistics, Common Core of Data; the US Census, Small Area Income and
Poverty Estimates; and the US Census, Education Demographic and
Geographic Estimates. Additional functions in the package create a
dataset of all school district neighbors as either a dataframe or a
shapefile and maps of selected districts at the state or neighbor level
symbolized by a selected variable in EdBuild’s master dataset. For full
details about EdBuild’s data processing please see EdBuild (2020)
[Methodology](http://data.edbuild.org/).

## Installation

You can install the released version of edbuildmapr from
[CRAN](https://CRAN.R-project.org) with:

``` r
install.packages("edbuildmapr")
```

## Example

To import school district spatial data for all districts with EdBuild’s
master data:

``` r
library(edbuildmapr)
## import school district shapefile for the year 2018 with EdBuild's master dataset attached. 
sd_shp_18 <- sd_shapepull("2018", with_data = TRUE)
#> Reading layer `shapefile_1718_4269' from data source `/private/var/folders/5n/cz5rxt2d02jcqlt7q25sy37m0000gp/T/RtmpCQgk5c/filef68a4f4911a/shapefile_1718_4269.shp' using driver `ESRI Shapefile'
#> Simple feature collection with 13330 features and 6 fields
#> geometry type:  MULTIPOLYGON
#> dimension:      XY
#> bbox:           xmin: -179.1686 ymin: 18.91382 xmax: 179.7487 ymax: 71.38881
#> CRS:            4269
#> NOTE::This shapefile has been simplified to make analysis quicker. For final vizualizations, please use the unsimplified shapefiles available through NCES.

str(sd_shp_18)
#> Classes 'sf' and 'data.frame':   13309 obs. of  46 variables:
#>  $ FIPS       : chr  "04" "04" "04" "04" ...
#>  $ GEOID      : chr  "0407530" "0401740" "0401160" "0400720" ...
#>  $ NAME       : chr  "Santa Cruz Valley Union High School District" "Casa Grande Union High School District" "Bicentennial Union High School District" "Antelope Union High School District" ...
#>  $ sdType     : chr  "secon" "secon" "secon" "secon" ...
#>  $ State      : chr  "Arizona" "Arizona" "Arizona" "Arizona" ...
#>  $ Postal     : chr  "AZ" "AZ" "AZ" "AZ" ...
#>  $ CONUM      : int  4021 4021 4012 4027 4027 4015 4013 4013 4013 4013 ...
#>  $ ENROLL     : int  367 3376 111 220 10959 1842 7780 4069 15029 27268 ...
#>  $ LRPP       : num  11275 5699 14189 11650 3136 ...
#>  $ SRPP       : num  2659 4295 1477 1195 4468 ...
#>  $ SLRPP      : num  13935 9994 15667 12845 7604 ...
#>  $ LR         : num  4138000 19241000 1575000 2563000 34370000 ...
#>  $ SR         : num  976000 14500000 164000 263000 48967000 ...
#>  $ SLR        : num  5114000 33741000 1739000 2826000 83337000 ...
#>  $ SRPP_cola  : num  2739 4423 1475 1249 4669 ...
#>  $ LRPP_cola  : num  11612 5870 14161 12173 3277 ...
#>  $ SLRPP_cola : num  14351 10293 15635 13423 7946 ...
#>  $ County     : chr  "Pinal County" "Pinal County" "La Paz County" "Yuma County" ...
#>  $ dType      : chr  "1-Regular local school district that is NOT a component of a supervisory union" "1-Regular local school district that is NOT a component of a supervisory union" "1-Regular local school district that is NOT a component of a supervisory union" "1-Regular local school district that is NOT a component of a supervisory union" ...
#>  $ urb        : chr  "31-Town: Fringe" "23-Suburb: Small" "43-Rural: Remote" "42-Rural: Distant" ...
#>  $ op_shcls   : int  2 2 1 2 7 3 5 4 11 17 ...
#>  $ enroll_ccd : int  367 3376 111 220 10959 1842 7780 4069 15029 27268 ...
#>  $ dFRL       : int  NA 2025 83 174 7627 1021 2938 NA 8672 22555 ...
#>  $ dLEP       : int  25 97 11 14 1234 26 129 126 809 2546 ...
#>  $ dWhite     : int  25 815 38 57 1333 958 2670 1410 4106 1223 ...
#>  $ dBlack     : int  31 123 0 0 133 32 798 291 1245 2288 ...
#>  $ dHispanic  : int  301 2043 72 162 9264 743 3699 2182 8606 22223 ...
#>  $ dAsian_PI  : int  1 50 0 0 56 16 246 37 487 456 ...
#>  $ dHaw_PI    : int  0 9 0 0 15 0 40 20 34 36 ...
#>  $ dAmInd_AK  : int  8 254 0 1 59 40 56 40 370 625 ...
#>  $ d2races    : int  1 82 1 0 99 53 271 89 181 417 ...
#>  $ pctNW      : num  0.932 0.759 0.658 0.741 0.878 ...
#>  $ TPop       : int  21741 103199 11246 6909 205219 67376 139522 76028 373568 754070 ...
#>  $ StPop      : int  747 5585 311 357 12121 2661 8131 4493 20614 44227 ...
#>  $ StPov      : int  157 1069 31 63 3167 609 817 530 4610 11530 ...
#>  $ StPovRate  : num  0.2102 0.1914 0.0997 0.1765 0.2613 ...
#>  $ MPV        : int  115800 126000 70500 80300 123300 137900 265300 198600 172100 169400 ...
#>  $ MHI        : int  44167 45789 30432 46047 43988 41673 75226 63832 44856 43643 ...
#>  $ sd_area    : num  718 1300 3809 3065 2454 ...
#>  $ st_per_sqmi: num  0.5109 2.5973 0.0291 0.0718 4.4654 ...
#>  $ sd_type    : chr  "secon" "secon" "secon" "secon" ...
#>  $ state_id   : chr  "AZ-4454" "AZ-4453" "AZ-4515" "AZ-4506" ...
#>  $ dIEP       : int  55 494 21 37 964 215 812 499 1875 3042 ...
#>  $ year       : chr  "2018" "2018" "2018" "2018" ...
#>  $ geometry   :sfc_MULTIPOLYGON of length 13309; first list element: List of 1
#>   ..$ :List of 1
#>   .. ..$ : num [1:135, 1:2] -111 -111 -111 -111 -111 ...
#>   ..- attr(*, "class")= chr  "XY" "MULTIPOLYGON" "sfg"
#>  $ frl_rate   : num  NA 0.6 0.748 0.791 0.696 ...
#>  - attr(*, "sf_column")= chr "geometry"
#>  - attr(*, "agr")= Factor w/ 3 levels "constant","aggregate",..: NA NA NA NA NA NA NA NA NA NA ...
#>   ..- attr(*, "names")= chr  "FIPS" "GEOID" "NAME" "sdType" ...
```

## Authors

  - Megan Brodzik (<meganbrodzik@edbuild.org>), maintainer
  - Cecilia Depman (<cecilia.depman@gmail.com>), author
  - Sara Hodges (<sara.hodges@gmail.com>), author
