% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emoa.sms-emoa.R
\name{smsemoa}
\alias{smsemoa}
\title{Implementation of the SMS-EMOA by Emmerich et al.}
\usage{
smsemoa(fitness.fun, n.objectives = NULL, n.dim = NULL, minimize = NULL,
  lower = NULL, upper = NULL, mu = 100L, ref.point = NULL,
  mutator = setup(mutPolynomial, eta = 25, p = 0.2, lower = lower, upper =
  upper), recombinator = setup(recSBX, eta = 15, p = 0.7, lower = lower, upper
  = upper), terminators = list(stopOnIters(100L)), ...)
}
\arguments{
\item{fitness.fun}{[\code{function}]\cr
The fitness function.}

\item{n.objectives}{[\code{integer(1)}]\cr
Number of objectives of \code{obj.fun}.
Optional if \code{obj.fun} is a benchmark function from package \pkg{smoof}.}

\item{n.dim}{[\code{integer(1)}]\cr
Dimension of the decision space.}

\item{minimize}{[\code{logical(n.objectives)}]\cr
Logical vector with ith entry \code{TRUE} if the ith objective of \code{fitness.fun}
shall be minimized. If a single logical is passed, it is assumed to be valid
for each objective.}

\item{lower}{[\code{numeric}]\cr
Vector of minimal values for each parameter of the decision space in case
of float or permutation encoding.
Optional if \code{obj.fun} is a benchmark function from package \pkg{smoof}.}

\item{upper}{[\code{numeric}]\cr
Vector of maximal values for each parameter of the decision space in case
of float or permutation encoding.
Optional if \code{obj.fun} is a benchmark function from package \pkg{smoof}.}

\item{mu}{[\code{integer(1)}]\cr
Number of individuals in the population.
Default is 100.}

\item{ref.point}{[\code{numeric}]\cr
Reference point for the hypervolume computation. Default is (11, ..., 11)'
with the corresponding dimension.}

\item{mutator}{[\code{ecr_mutator}]\cr
Mutation operator of type \code{ecr_mutator}.}

\item{recombinator}{[\code{ecr_recombinator}]\cr
Recombination operator of type \code{ecr_recombinator}.}

\item{terminators}{[\code{list}]\cr
List of stopping conditions of type \dQuote{ecr_terminator}.
Default is to stop after 100 iterations.}

\item{...}{[any]\cr
Further arguments passed down to fitness function.}
}
\value{
[\code{ecr_multi_objective_result}]
}
\description{
Pure R implementation of the SMS-EMOA. This algorithm belongs to the group
of indicator based multi-objective evolutionary algorithms. In each generation,
the SMS-EMOA selects two parents uniformly at, applies recombination and mutation
and finally selects the best subset of individuals among all subsets by maximizing
the Hypervolume indicator.
}
\note{
This helper function hides the regular ecr interface and offers a more
R like interface of this state of the art EMOA.
}
\references{
Beume, N., Naujoks, B., Emmerich, M., SMS-EMOA: Multiobjective selection based
on dominated hypervolume, European Journal of Operational Research, Volume 181,
Issue 3, 16 September 2007, Pages 1653-1669.
}
\keyword{optimize}
