% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operator.selector.roulettewheel.R
\name{setupRouletteWheelSelector}
\alias{setupRouletteWheelSelector}
\title{Generator for Roulette-Wheel-Selection (fitness-proportional selection).}
\usage{
setupRouletteWheelSelector(offset = 0.1)
}
\arguments{
\item{offset}{[\code{numeric(1)}]\cr
In case of negative fitness values all values are shifted towards positive
values by adding the negative of the minimal fitness value. However, in this
case the minimal fitness value after the shifting process is zero. The
\code{offset} is a positive numeric value which is added additionally to each
shifted fitness value. This way even the individual with the smallest fitness
value has a positive porbability to be selected.
Default is \code{0.1}.}
}
\value{
[\code{setOfIndividuals}]
}
\description{
Selects genes for the mating pool. The chance of an individual to get selected
is proportional to its fitness, i.e., better individuals get a higher chance
to take part in the reproduction process. Low-fitness individuals however,
have a positive fitness as well.
}
\details{
Fitness proportional selection can be naturally applied to single objective
maximization problems. However, negative fitness values can are problematic.
The Roulette-Wheel selector thus works with the following heuristic: if
negative values occur, the negative of the smallest fitness value is added
to each fitness value. In this case to avoid the smallest shifted fitness
value to be zero and thus have a zero probability of being selected an additional
positive constant \code{offset} is added (see parameters).
}
\seealso{
Other selectors: \code{\link{setupDominatedHypervolumeSelector}},
  \code{\link{setupGreedySelector}},
  \code{\link{setupNondomSelector}},
  \code{\link{setupSimpleSelector}},
  \code{\link{setupTournamentSelector}}
}

