% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LCx.R
\name{LC_logit}
\alias{LC_logit}
\title{Lethal Concentration Logit}
\usage{
LC_logit(formula, data, p = NULL, weights = NULL,
         subset = NULL, log_base = NULL,
         log_x = TRUE, het_sig = NULL,
         conf_level = NULL, long_output = TRUE)
}
\arguments{
\item{formula}{an object of class \code{formula} or one that can be coerced to that class): a symbolic description of the model to be fitted. The details of model specification are given under Details.}

\item{data}{an optional data frame, list or environment (or object coercible by as.data.frame to a data frame) containing the variables in the model. If not found in data, the variables are taken from environment(formula), typically the environment from which \code{LC_logit} is called.}

\item{p}{Lethal Concentration (LC) values for given p, example will return a LC50 value if p equals 50. If more than one LC value wanted specify by creating a vector. LC values can be calculated down to the 1e-16 of a percentage (e.g. LC99.99). However, the tibble produced can round to nearest whole number.}

\item{weights}{vector of 'prior weights' to be used in the fitting process. Only needs to be supplied if you are taking the response / total for your response variable within the formula call of \code{LC_probit}. Otherwise if you use cbind(response, non-response) method you do not need to supply weights. If you do the model will be incorrect. If you don't supply weights there is a warning that will help you to make sure you are using one method or the other.See the following StackExchange post about differences \href{https://stats.stackexchange.com/questions/259502/in-using-the-cbind-function-in-r-for-a-logistic-regression-on-a-2-times-2-t}{cbind() function in R for a logistic regression}.}

\item{subset}{allows for the data to be subseted if desired. Default set to \code{NULL}.}

\item{log_base}{default is \code{10} and will be used to  calculate results using the anti of \code{log10()} given that the x variable has been \code{log10} tranformed. If \code{FALSE} results will not be back transformed.}

\item{log_x}{default is \code{TRUE} and will calculate results using the antilog of determined by \code{log_base} given that the x variable has been \code{log()} tranformed. If \code{FALSE} results will not be back transformed.}

\item{het_sig}{significance level from person's chi square goodness-of-fit test that is used to decide if a heterogeneity factor is used. \code{NULL} is set to 0.15.}

\item{conf_level}{adjust confidence level as necessary or \code{NULL} set at 0.95.}

\item{long_output}{default is \code{TRUE} which will return a tibble with all 19 variabless. If \code{FALSE} the tibble returned will consist of the p level, n, the predicted LC for given p level, lower and upper confidence limits and their distances.}
}
\value{
Returns a tibble with predicted LC for given p level, lower CL (LCL), upper CL (UCL), LCL and UCL distance away from LC (LCL_dis & UCL_dis; important for creating a plot), Pearson's chi square goodness-of-fit test (pgof), slope, intercept, slope and intercept p values and standard error, and LC variance.
}
\description{
Calculates lethal concentration (LC) and
its fiducial confidence limits (CL) using a logit analysis
according to Finney 1971, Wheeler et al. 2006, and Robertson et al. 2007.
}
\examples{
head(lamprey_tox)

# within the dataframe used, control dose, unless produced a value
# during experimentation, are removed from the dataframe,
# as glm cannot handle values of infinite. Other statistical programs
# make note of the control dose but do not include within analysis


# calculate LC50 and LC99 for May

m <- LC_logit((response / total) ~ log10(dose), p = c(50, 99),
         weights = total,
         data = lamprey_tox[lamprey_tox$nominal_dose != 0, ],
         subset = c(month == "May"))


# OR

m1 <- LC_logit(cbind(response, survive) ~ log10(dose), p = c(50, 99),
               data = lamprey_tox[lamprey_tox$nominal_dose != 0, ],
               subset = c(month == "May"))


# view calculated LC50 and LC99 for seasonal toxicity of a pisicide,
# to lamprey in 2011

m

# they are the same

m1

# dose-response curve can be plotted using 'ggplot2'
# Uncomment the below lines to run create plots

# library(ggplot2)

# lc_may <- subset(lamprey_tox, month \%in\% c("May"))

# p1 <- ggplot(data = lc_may[lc_may$nominal_dose != 0, ],
#              aes(x = log10(dose), y = (response / total))) +
# geom_point() +
# geom_smooth(method = "glm",
#             method.args = list(family = binomial(link = "logit")),
#             aes(weight = total), colour = "#FF0000", se = TRUE)

# p1

# calculate LC50s and LC99s for multiple toxicity tests, June, August, and September

j <- LC_logit((response / total) ~ log10(dose), p = c(50, 99),
        weights = total,
        data = lamprey_tox[lamprey_tox$nominal_dose != 0, ],
        subset = c(month == "June"))

a <- LC_logit((response / total) ~ log10(dose), p = c(50, 99),
        weights = total,
        data = lamprey_tox[lamprey_tox$nominal_dose != 0, ],
        subset = c(month == "August"))

s <- LC_logit((response / total) ~ log10(dose), p = c(50, 99),
        weights = total,
        data = lamprey_tox[lamprey_tox$nominal_dose != 0, ],
        subset = c(month == "September"))

# group results together in a dataframe to plot with 'ggplot2'

results <- rbind(m[, c(1, 3:8, 11)], j[,c(1, 3:8, 11)],
                 a[, c(1, 3:8, 11)], s[, c(1, 3:8, 11)])
results$month <- factor(c(rep("May", 2), rep("June", 2),
                          rep("August", 2), rep("September", 2)),
                        levels = c("May", "June", "August", "September"))


# p2 <- ggplot(data = results, aes(x = month, y = dose,
#                              group = factor(p), fill = factor(p))) +
#   geom_col(position = position_dodge(width = 0.9), colour = "#000000") +
#   geom_errorbar(aes(ymin = (dose - LCL_dis), ymax = (dose + UCL_dis)),
#                 size = 0.4, width = 0.06,
#                 position = position_dodge(width = 0.9))

# p2
}
\references{
Finney, D.J., 1971. Probit Analysis, Cambridge University Press, Cambridge, England, ISBN: 052108041X

Wheeler, M.W., Park, R.M., and Bailey, A.J., 2006. Comparing median lethal concentration values using confidence interval overlap or ratio tests, Environ. Toxic. Chem. 25(5), 1441-1444.10.1897/05-320R.1

Robertson, J.L., Savin, N.E., Russell, R.M. and Preisler, H.K., 2007. Bioassays with arthropods. CRC press. ISBN: 9780849323317
}
