% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balassa_index.R
\name{balassa_index}
\alias{balassa_index}
\title{Balassa Index}
\usage{
balassa_index(
  data,
  discrete = TRUE,
  cutoff = 1,
  country = "country",
  product = "product",
  value = "value"
)
}
\arguments{
\item{data}{(Type: data.frame, matrix or dgCMatrix) a dataset such as
\code{galactic_federation} containing countries, products and exported values.}

\item{discrete}{(Type: logical) whether converting the Balassa Index to
discrete (0/1) values. Anything below the specified cutoff is converted to 0
and 1 otherwise. By default this is set to \code{TRUE}.}

\item{cutoff}{(Type: numeric) the cutoff to use for discretization.
By default this is set to \code{1}.}

\item{country}{(Type: character) the column with the countries.
By default this is set to \code{"country"}. Used only if the input is a data.frame.}

\item{product}{(Type: character) the column with the products.
By default this is set to \code{"product"}. Used only if the input is a data.frame.}

\item{value}{(Type: character) the column with the metric for
country-product pairs.
By default this is set to \code{"value"}. Used only if the input is a data.frame.}
}
\value{
A matrix with the Balassa Index.
}
\description{
\code{balassa_index()} computes the Balassa Index for a
bipartite relation between countries and products.
}
\details{
The current implementation follows
\insertCite{measuringcomplexity2015}{economiccomplexity} to obtain a metric for
specialisation. In the context of international trade, if the Balassa Index
for a country-product pair is more than 1, it means that country is
specialized in that product. If the input for this function is a data.frame
instead of a matrix, the function shall aggregate the data and convert the
input to a matrix.
}
\examples{
bi <- balassa_index(world_trade_avg_1998_to_2000)

# partial view of index
bi[1:5,1:5]

}
\references{
For more information see:

\insertRef{measuringcomplexity2015}{economiccomplexity}

and the references therein.
}
\keyword{functions}
