% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/revealed_comparative_advantage.R
\name{revealed_comparative_advantage}
\alias{revealed_comparative_advantage}
\title{Revealed Comparative Advantage (RCA)}
\usage{
revealed_comparative_advantage(trade_data = NULL, country = "country",
  product = "product", value = "value", cutoff = 1,
  discrete = TRUE, tbl_output = FALSE)
}
\arguments{
\item{trade_data}{tibble/data.frame in long format, it must contain the columns country (character/factor),
product (character/factor) and export value (numeric)}

\item{country}{string to indicate the column that contains exporting countries (e.g. "reporter_iso")}

\item{product}{string to indicate the column that contains exported products (e.g. "product_code")}

\item{value}{string to indicate the column that contains traded values (e.g. "trade_value_usd")}

\item{cutoff}{when set to TRUE all the values lower than the specified cutoff will be
converted to zero and to one in other case, numeric (default set to 1)}

\item{discrete}{when set to TRUE it will convert all the Revealed Comparative Advantage values
to zero or one based on the cutoff value (default set to TRUE)}

\item{tbl_output}{when set to TRUE the output will be a tibble instead of a matrix (default set to FALSE)}
}
\description{
Revealed Comparative Advantage (RCA)
}
\examples{
revealed_comparative_advantage(
 trade_data = services_trade_2016$services_trade_2016_matrix,
 tbl_output = TRUE
)
}
\references{
For more information on revealed comparative advantage and its uses see:

\insertRef{atlas2014}{economiccomplexity}
}
\keyword{functions}
