% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networks.R
\name{networks}
\alias{networks}
\title{Networks}
\usage{
networks(proximity_countries, proximity_products, countries_cutoff = 0.2,
  products_cutoff = 0.4, tbl_output = FALSE)
}
\arguments{
\item{proximity_countries}{matrix or tibble/data.frame, if d is a tibble/data.frame it must contain the columns
from (character/factor), to (character/factor) and value (numeric), if it is a matrix it must be a
numeric matrix with countries in row names and column names}

\item{proximity_products}{matrix or tibble/data.frame, if d is a tibble/data.frame it must contain the columns
from (character/factor), to (character/factor) and value (numeric), if it is a matrix it must be a
numeric matrix with products in row names and column names}

\item{countries_cutoff}{all the values lower than the specified countries_cutoff will be converted to 0 and excluded
from the countries network (default set to 0.2)}

\item{products_cutoff}{all the values lower than the specified products_cutoff will be converted to 0 and excluded
from the products network (default set to 0.4)}

\item{tbl_output}{when set to TRUE the output will be a tibble instead of a graph (default set to FALSE)}
}
\description{
Networks
}
\examples{
networks(
 proximity_countries =
  package_output_demo$proximity_matrix$proximity_countries,
 proximity_products =
  package_output_demo$proximity_matrix$proximity_products,
 tbl_output = TRUE
)
}
\references{
For more information on networks such as the product space and its applications see:

\insertRef{atlas2014}{economiccomplexity}
}
\keyword{functions}
