% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_observation_ancillary.R
\name{create_observation_ancillary}
\alias{create_observation_ancillary}
\title{Create the observation_ancillary table}
\usage{
create_observation_ancillary(
  L0_flat,
  observation_id,
  variable_name,
  unit = NULL
)
}
\arguments{
\item{L0_flat}{(tbl_df, tbl, data.frame) The fully joined source L0 dataset, in "flat" format (see details).}

\item{observation_id}{(character) Column in \code{L0_flat} containing the identifier assigned to each unique observation.}

\item{variable_name}{(character) Columns in \code{L0_flat} containing the ancillary observation data.}

\item{unit}{(character) An optional column in \code{L0_flat} containing the units of each \code{variable_name} following the column naming convention: unit_<variable_name> (e.g. "unit_temperature").}
}
\value{
(tbl_df, tbl, data.frame) The observation_ancillary table.
}
\description{
Create the observation_ancillary table
}
\details{
This function collects specified columns from \code{L0_flat}, converts into long (attribute-value) form by gathering \code{variable_name}. Regular expression matching joins \code{unit} to any associated \code{variable_name} and is listed in the resulting table's "unit" column.

"flat" format refers to the fully joined source L0 dataset in "wide" form with the exception of the core observation variables, which are in "long" form (i.e. using the variable_name, value, unit columns of the observation table). This "flat" format is the "widest" an L1 ecocomDP dataset can be consistently spread due to the frequent occurrence of L0 source datasets with > 1 core observation variable.
}
\examples{
flat <- ants_L0_flat

observation_ancillary <- create_observation_ancillary(
  L0_flat = flat,
  observation_id = "observation_id", 
  variable_name = c("trap.type", "trap.num", "moose.cage"))

observation_ancillary

}
