% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebv_download.R
\name{ebv_download}
\alias{ebv_download}
\title{Download an EBV netCDF file}
\usage{
ebv_download(id = NULL, outputdir, overwrite = FALSE, verbose = TRUE)
}
\arguments{
\item{id}{Integer or Character. Must be a single integer value or a character
string representing the title of the data set. Both can be retrieved by
running \code{\link[=ebv_download]{ebv_download()}} without any arguments which returns the
list of data sets available and their title and ID.}

\item{outputdir}{Character. Output directory of the downloaded files.}

\item{overwrite}{Logical. Default: FALSE. Set to TRUE if you want to
overwrite the netCDF and json.}

\item{verbose}{Logical. Default: TRUE. Turn off additional prints by setting
it to FALSE.}
}
\value{
Downloades a netCDF and json file to the given output directory.
}
\description{
Returns the list of all available data sets at the EBV Portal if
you no arguments are given. If an ID is given, the corresponding file
(netCDF) and its metadata (json file) will be downloaded to the given
output directory.
}
\examples{
#get all available datasets
datasets <- ebv_download()

\donttest{
ebv_download(id = datasets$id[1], outputdir =
file.path(system.file(package='ebvcube')), overwrite=TRUE,
verbose=FALSE)
}
}
