% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applyLookup.R
\name{applyLookup}
\alias{applyLookup}
\title{Recode via lookup table.}
\usage{
applyLookup(GADSdat, lookup, suffix = NULL)
}
\arguments{
\item{GADSdat}{A \code{GADSdat} object.}

\item{lookup}{Lookup table created by \code{\link{createLookup}} and - if necessary -  collapsed by \code{\link{collapseColumns}}.
Column names must be \code{c("variable", "value", "value_new")}.}

\item{suffix}{Suffix to add to the existing variable names. If \code{NULL}, the old variables will be overwritten.}
}
\value{
Returns a recoded \code{GADSdat}.
}
\description{
Recode one or multiple variables based on a lookup table created via \code{\link{createLookup}}
(and potentially formatted by \code{\link{collapseColumns}}).
}
\details{
If there are missing values in the column \code{value_new}, \code{NAs} are inserted as new values
and a \code{warning} is issued.

The complete work flow when using a lookup table to recode multiple variables in a \code{GADSdat} could be:
(0) optional: Recode empty strings to \code{NA} (necessary, if the look up table is written to excel).
(1) create a lookup table with \code{\link{createLookup}}.
(2) Save the lookup table to \code{.xlsx} with \code{write_xlsx} from \code{eatAnalysis}.
(3) fill out the lookup table via \code{Excel}.
(4) Import the lookup table back to \code{R} via \code{read_excel} from \code{readxl}.
(5) Apply the final lookup table with \code{applyLookup}.

See \code{\link{applyLookup_expandVar}} for recoding a single variable into multiple variables.
}
\examples{
## create an example GADSdat
iris2 <- iris
iris2$Species <- as.character(iris2$Species)
gads <- import_DF(iris2)

## create Lookup
lu <- createLookup(gads, recodeVars = "Species")
lu$value_new <- c("plant 1", "plant 2", "plant 3")

## apply lookup table
gads2 <- applyLookup(gads, lookup = lu, suffix = "_r")

## only recode some values
lu2 <- createLookup(gads, recodeVars = "Species")
lu2$value_new <- c("plant 1", "plant 2", NA)
gads3 <- applyLookup(gads, lookup = lu2, suffix = "_r")

}
