% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspectDifferences.R
\name{inspectDifferences}
\alias{inspectDifferences}
\title{Inspect differences in a variable.}
\usage{
inspectDifferences(varName, GADSdat1, GADSdat2, id)
}
\arguments{
\item{varName}{A character vector of length 1 containing the variable name.}

\item{GADSdat1}{A \code{GADSdat} object.}

\item{GADSdat2}{A \code{GADSdat} object.}

\item{id}{A character vector of length 1 containing the unique identifier column of both \code{GADSdat}.}
}
\value{
A list.
}
\description{
Inspect differences between two \code{GADSdat} objects in a specific variable.
}
\details{
Two \code{GADSdat} objects can be compared using \code{\link{equalGADS}}. If differences in the data are indicated for specific variables,
these variables can be further inspected using \code{inspectDifferences}.
}
\examples{
# create a second GADS with different data
pisa2 <- pisa
pisa2$dat$age[400:nrow(pisa$dat)] <- sample(pisa2$dat$age[400:nrow(pisa$dat)])

# inspect via equalGADS()
equalGADS(pisa, pisa2)

# inspect via inspectDifferences()
inspectDifferences("age", GADSdat1 = pisa, GADSdat2 = pisa2, id = "idstud")

}
