% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeVars.R
\name{extractVars}
\alias{extractVars}
\alias{removeVars}
\title{Extract or remove variables from a \code{GADSdat}.}
\usage{
extractVars(GADSdat, vars)

removeVars(GADSdat, vars)
}
\arguments{
\item{GADSdat}{\code{GADSdat} object.}

\item{vars}{A character vector containing the variables names in the \code{GADSdat}.}
}
\value{
Returns a \code{GADSdat} object.
}
\description{
Extract or remove variables and their meta data from a \code{GADSdat} object.
}
\details{
Both functions simply perform the variable removal or extraction from the underlying \code{data.frame}
in the \code{GADSdat} object followed by calling \code{\link{updateMeta}}.
}
\examples{
## create an example GADSdat
example_df <- data.frame(ID = 1:4,
                        age = c(12, 14, 16, 13),
                        citizenship1 = c("German", "English", "Polish", "Chinese"),
                        citizenship2 = c(NA, "German", "Chinese", "Polish"),
                        stringsAsFactors = TRUE)
gads <- import_DF(example_df)

## remove variables from GADSdat
gads2 <- removeVars(gads, vars = c("citizenship2", "age"))

## extract GADSdat with specific variables
gads3 <- extractVars(gads, vars = c("ID", "citizenship1"))
}
