% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_stata.R
\name{import_stata}
\alias{import_stata}
\title{Import Stata data}
\usage{
import_stata(filePath, checkVarNames = TRUE, labeledStrings = FALSE)
}
\arguments{
\item{filePath}{Source file location, ending on \code{.dta}.}

\item{checkVarNames}{Should variable names be checked for violations of \code{SQLite} and \code{R} naming rules?}

\item{labeledStrings}{Should strings as labeled values be allowed? This possibly corrupts all labeled values.}
}
\value{
Returns a list with the actual data \code{dat} and a data frame with all meta information in long format \code{labels}.
}
\description{
Function to import \code{.dta} files while extracting meta information, e.g. variable and value labels.
}
\details{
Stata files (\code{.dta}) store variable and value labels and assign specific formatting to variables. \code{import_stata} imports
data from Stata, while storing this meta-information separately in a long format data frame. Time and date variables are converted to character.
}
