% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/n_multiway.R
\name{n.multiway}
\alias{n.multiway}
\title{Sample size calculations for factorial ANOVAs}
\usage{
n.multiway(iv1 = NULL, iv2 = NULL, iv3 = NULL, iv4 = NULL,
  interaction.eta2 = "small", sig.level = 0.05, power = 0.8,
  result = "all", ...)
}
\arguments{
\item{iv1}{The list of data for treatment 1.}

\item{iv2}{The list of data for treatment 2.}

\item{iv3}{(optional) The list of data for treatment 3.}

\item{iv4}{(optional) The list of data for treatment 4.}

\item{interaction.eta2}{(optional) Either a character string or numeric value of the desired eta squared. Default is set to "small".}

\item{sig.level}{(optional) Desired significance level. Default value is 0.05.}

\item{power}{(optional) Desired level of power. Default value is 0.80.}

\item{result}{The amount of data that will be output to the user (\emph{default = "all"}).
The following are the three output options the user may specify:
\itemize{
 \item result = "all" - Outputs the sample size recommendations for all treatments and all possible interactions.
 \item result = "highest" - Outputs the highest recommended sample size.
 \item result = "select" - Outputs specific results to the user. If there has been previous research on an
 effect, the user may input a numeric value for the effect size. The output will consist of the highest recommended sample size
 and the recommendations where the user input a numeric value for the effect size of a treatment.
}}

\item{...}{Extra interactions to pass in. In order to change the effect size of a specific interaction an
interaction effect may be added to the function. It must take the form: \emph{int# = int.eff.#}.}
}
\description{
Sample size calculations for factorial ANOVAs
}
\details{
Acceptable effect size character string values and their numeric equivalents are: "small" (0.01), "med" (0.06), and "large" (0.14).
}
\note{
Sample size recommendations are rounded up to the nearest integer. More detailed examples on n.multiway can be viewed in the vignette.
}
\examples{
# Exercise 8.15, p.400 from Cohen (1988)
# Defining the treatments
main.eff.1 <- list(name = "R", levels = 2, eta.sq = 0.123)
main.eff.2 <- list(name = "C", levels = 4, eta.sq = 0.215)
# Running n.multiway
n.multiway(iv1=main.eff.1, iv2=main.eff.2, interaction.eta2 = 0.079)
# To just view highest
n.multiway(iv1=main.eff.1, iv2=main.eff.2, interaction.eta2 = 0.079, result = "highest")

# Exercise 8.14, p.397 from Cohen (1988)
# Defining the treatments and interaction
main.eff.1 <- list(name = "Sex", levels = 2, eta.sq = 0.0099)
main.eff.2 <- list(name = "Age", levels = 3, eta.sq = 0.0588)
main.eff.3 <- list(name = "Conditions", levels = 4, eta.sq = 0.1506)
# Running n.multiway
n.multiway(iv1=main.eff.1, iv2=main.eff.2, iv3=main.eff.3, interaction.eta2 = 0.0588)
}
\references{
Cohen, J. (1988). \emph{Statistical power analysis for the behavioral sciences} (2nd ed.). Hillsdale, N.J.: Lawrence Erlbaum Associates.
}

