% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_scielo.R
\name{search_scielo}
\alias{search_scielo}
\title{Search SciELO and return results as a data.frame}
\usage{
search_scielo(
  query,
  lang = "en",
  lang_operator = "AND",
  n_max = NULL,
  journals = NULL,
  collections = NULL,
  languages = NULL,
  categories = NULL,
  year_start = NULL,
  year_end = NULL
)
}
\arguments{
\item{query}{Search term (e.g., "climate change"). Required.}

\item{lang}{Interface language for SciELO website ("en", "es", "pt"). Default is "en".}

\item{lang_operator}{Operator for combining language filters ("AND" or "OR"). Default is "AND".}

\item{n_max}{Maximum number of results to return. Optional.}

\item{journals}{Vector of journal names to filter. Only one supported. Optional.}

\item{collections}{A character string for filtering by SciELO collection (country name or ISO code, e.g., "Mexico" or "mex").}

\item{languages}{Vector of article languages to filter (e.g., "en").}

\item{categories}{Vector of subject categories (e.g., "ecology").}

\item{year_start}{Start year for filtering articles. Optional.}

\item{year_end}{End year for filtering articles. Optional.}
}
\value{
A data.frame with the search results.
}
\description{
Executes a search in the SciELO database using multiple optional filters,
and returns the results as a data frame.
}
\details{
Note: Only one value per filter category is currently supported (e.g., only one language).
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# Simple search with a keyword
df1 <- search_scielo("salud ambiental")

# Limit number of results to 5
df2 <- search_scielo("salud ambiental", n_max = 5)

# Filter by SciELO collection (country name or code)
df3 <- search_scielo("salud ambiental", collections = "Ecuador")
df4 <- search_scielo("salud ambiental", collections = "cri")  # Costa Rica by ISO code

# Filter by article language
df5 <- search_scielo("salud ambiental", languages = "es")

# Filter by a specific journal
df6 <- search_scielo("salud ambiental", journals = "Revista Ambiente & Agua")

# Filter by subject category
df7 <- search_scielo("salud ambiental", categories = "environmental sciences")

# Filter by year range
df8 <- search_scielo("salud ambiental", year_start = 2015, year_end = 2020)
}
\dontshow{\}) # examplesIf}
}
