% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pointCloudAnalysis3D.R
\name{saveImageSlices}
\alias{saveImageSlices}
\title{Export a dataCube as image slice sequence}
\usage{
saveImageSlices(rStack, filename, dir, NaVal = 0)
}
\arguments{
\item{rStack}{rasterStack to be saved to Tiff image slices}

\item{filename}{name of the image slices}

\item{dir}{directory, where the slices should be stored}

\item{NaVal}{numeric value that should represent NA values in the Tiff image, default is \code{NaVal = 0}}
}
\value{
Saves the Tiff image files.
}
\description{
Exports a dataCube of type \code{rasterStack} as Tiff image sequence.
Image sequnces are a common structre to represent voxel data and
most of the specific software to visualize voxel data is able to read it (e.g. blender)
}
\examples{
crws <- lapply(X=seq(1:100), FUN = function(X) {
  sim.crw.3d(nStep = 100, rTurn = 0.99, rLift = 0.99, meanStep = 0.1)
})
points <- do.call("rbind", crws)
extent <- raster::extent(c(-10, 10, -10, 10))
ud <- voxelCount(points, extent, xyRes=5,
                 zMin=-10, zMax=10, standartize = TRUE)
saveImageSlices(ud, filename = "saveImageSlices_test", dir = tempdir())
}
