% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_numeric_range.R
\name{numeric_range_parameter}
\alias{numeric_range_parameter}
\title{Define a numeric range parameter}
\usage{
numeric_range_parameter(
  id,
  default,
  lower_distribution,
  upper_distribution,
  description = NULL,
  tuneable = TRUE
)
}
\arguments{
\item{id}{The name of the parameter.}

\item{default}{The default value of the parameter.}

\item{lower_distribution}{A distribution from which the lower value of the range can be sampled.}

\item{upper_distribution}{A distribution from which the upper value fo the range can be sampled.}

\item{description}{An optional (but recommended) description of the parameter.}

\item{tuneable}{Whether or not a parameter is tuneable.}
}
\description{
Define a numeric range parameter
}
\examples{
numeric_range_parameter(
  id = "quantiles",
  default = c(0.1, 0.99),
  lower_distribution = uniform_distribution(0, 0.25),
  upper_distribution = uniform_distribution(0.9, 1),
  description = "The lower and upper quantile thresholds."
)
}
\seealso{
\link{dynparam} for an overview of all dynparam functionality.
}
