% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimred_tsne.R
\name{dimred_tsne}
\alias{dimred_tsne}
\title{tSNE}
\usage{
dimred_tsne(
  x,
  ndim = 2,
  perplexity = 30,
  theta = 0.5,
  initial_dims = 50,
  distance_method = c("pearson", "spearman", "cosine", "euclidean", "manhattan")
)
}
\arguments{
\item{x}{Log transformed expression data, with rows as cells and columns as features}

\item{ndim}{The number of dimensions}

\item{perplexity}{numeric; Perplexity parameter (should not be bigger than 3 * perplexity < nrow(X) - 1, see details for interpretation)}

\item{theta}{numeric; Speed/accuracy trade-off (increase for less accuracy), set to 0.0 for exact TSNE (default: 0.5)}

\item{initial_dims}{integer; the number of dimensions that should be retained in the initial PCA step (default: 50)}

\item{distance_method}{The name of the distance metric, see \link[dynutils:calculate_distance]{dynutils::calculate_distance}}
}
\description{
tSNE
}
\examples{
library(Matrix)
dataset <- abs(Matrix::rsparsematrix(100, 100, .5))
dimred_tsne(dataset, ndim = 3)
}
\seealso{
\code{\link[Rtsne:Rtsne]{Rtsne::Rtsne()}}
}
