% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PF.R
\name{PF_control}
\alias{PF_control}
\title{Auxiliary for Controlling Particle Fitting}
\usage{
PF_control(N_fw_n_bw = NULL, N_smooth = NULL, N_first = NULL,
  eps = 0.01, forward_backward_ESS_threshold = NULL,
  method = "AUX_normal_approx_w_cloud_mean", n_max = 25,
  n_threads = getOption("ddhazard_max_threads"), smoother = "Fearnhead_O_N",
  Q_tilde = NULL, est_a_0 = TRUE)
}
\arguments{
\item{N_fw_n_bw}{number of particles to use in forward and backward filter.}

\item{N_smooth}{number of particles to use in particle smoother.}

\item{N_first}{number of particles to use at time \eqn{0} and time \eqn{d + 1}.}

\item{eps}{convergence threshold in EM method.}

\item{forward_backward_ESS_threshold}{required effective sample size to not re-sample in the particle filters.}

\item{method}{method for forward, backward and smoothing filter.}

\item{n_max}{maximum number of iterations of the EM algorithm.}

\item{n_threads}{maximum number threads to use in the computations.}

\item{smoother}{smoother to use.}

\item{Q_tilde}{covariance matrix of additional error term to add to the
proposal distributions. \code{NULL} implies no additional error term.}

\item{est_a_0}{\code{FALSE} if the starting value of the state model should
be fixed. Does not apply for \code{type = "VAR"}.}
}
\value{
A list with components named as the arguments.
}
\description{
Auxiliary for additional settings with \code{\link{PF_EM}}.
}
\seealso{
\code{\link{PF_EM}}
}
