% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamac.R
\name{ldshift}
\alias{ldshift}
\title{Take the lagged first difference of a series}
\usage{
ldshift(x, l)
}
\arguments{
\item{x}{a series to be differenced}

\item{l}{the number of lags}
}
\value{
the lagged differenced series
}
\description{
Take the lagged first difference of a series
}
\details{
\code{ldshift} assumes that the series are ordered, that there is no missing data, and that the time intervals are even
}
\examples{
x.var <- runif(50)
ld.1.x.var <- ldshift(x.var, 1)
ld.2.x.var <- ldshift(x.var, 2)
head(x.var)
head(ld.1.x.var)
head(ld.2.x.var)
}
\author{
Soren Jordan and Andrew Q. Philips
}
\keyword{utilities}
