% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adci_sp.R
\name{adci_sp}
\alias{adci_sp}
\title{Summaries of mosquito abundance (spatial)}
\usage{
adci_sp(
  input_sim = NULL,
  coords = NULL,
  eval_date = NULL,
  stage = 1,
  breaks = c(0.25, 0.5, 0.75)
)
}
\arguments{
\item{input_sim}{matrix. dynamAedes compressed output matrix}

\item{coords}{matrix. A matrix reporting the spatial coordinates of the temperature observations.}

\item{eval_date}{positive integer. Define the day of successful introduction evaluation, referring to the column number of the temperature matrix used to inform the model.}

\item{stage}{positive integer. 0 (all), 1 (egg), 2 (juvenile), 3 (adult), 4 (diapausing egg).}

\item{breaks}{numeric vector. Quantile breaks, default the first, the second and the third quantile: \code{c(0.25,0.5,0.75)}.}
}
\value{
Returns a raster with the summary of mosquito abundance at each life stage for each day.
}
\description{
Summaries of mosquito abundance at each life stage for each day.
}
\author{
Matteo Marcantonio \email{marcantoniomatteo@gmail.com}, Daniele Da Re \email{daniele.dare@uclouvain.be}
}
