/*
 * Decompiled with CFR 0.152.
 */
package jas.util;

import jas.util.DateListener;
import jas.util.DateModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;

class CalendarPane
extends JComponent
implements DateListener,
ActionListener {
    private JButton selectedButton;
    private Color fg;
    private Color bg;
    private Dimension buttonSize;
    private Dimension panelSize;
    private Point hidden;
    private DateModel model;
    private JButton[] days;
    private static final String[] labels = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};

    CalendarPane(DateModel model) {
        int i;
        this.model = model;
        model.addDateListener(this);
        this.setLayout(null);
        Insets insets = new Insets(1, 1, 1, 1);
        this.days = new JButton[31];
        for (i = 0; i < 31; ++i) {
            this.days[i] = new JButton(String.valueOf(i + 1));
            this.days[i].addActionListener(this);
            this.add(this.days[i]);
        }
        this.fg = this.days[30].getForeground();
        this.bg = this.days[30].getBackground();
        this.buttonSize = this.days[30].getPreferredSize();
        this.panelSize = new Dimension(this.buttonSize.width * 7, this.buttonSize.height * 7);
        this.hidden = new Point(this.buttonSize.width * 10, this.buttonSize.height * 10);
        for (i = 0; i < 31; ++i) {
            this.days[i].setSize(this.buttonSize);
        }
        for (i = 0; i < 7; ++i) {
            JLabel l = new JLabel(labels[i], 0);
            this.add(l);
            l.setLocation(i * this.buttonSize.width, 0);
            l.setSize(this.buttonSize);
        }
        this.layoutCalendar();
    }

    public Dimension getPreferredSize() {
        return this.panelSize;
    }

    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        int day = Integer.valueOf(s);
        this.model.set(5, day);
    }

    public void dateChanged() {
        this.layoutCalendar();
    }

    void layoutCalendar() {
        int i;
        Calendar selected = this.model.getCalendar();
        int day = selected.get(5) - 1;
        if (this.selectedButton != this.days[day]) {
            if (this.selectedButton != null) {
                this.selectedButton.setForeground(this.fg);
                this.selectedButton.setBackground(this.bg);
                this.selectedButton.repaint();
            }
            this.selectedButton = this.days[day];
            this.selectedButton.setForeground(UIManager.getColor("textHighlightText"));
            this.selectedButton.setBackground(UIManager.getColor("textHighlight"));
            this.selectedButton.repaint();
        }
        Calendar date = (Calendar)selected.clone();
        date.set(5, 1);
        for (i = 0; i < this.model.getDaysInMonth(); ++i) {
            int x = (date.get(7) - 1) * this.buttonSize.width;
            int y = date.get(4) * this.buttonSize.height;
            this.days[i].setLocation(x, y);
            date.add(5, 1);
        }
        while (i < 31) {
            this.days[i].setLocation(this.hidden);
            ++i;
        }
    }
}

