/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.JASHistStyle;
import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class JASHist2DHistogramStyle
extends JASHistStyle
implements Serializable {
    public static final int STYLE_BOX = 0;
    public static final int STYLE_ELLIPSE = 1;
    public static final int STYLE_COLORMAP = 2;
    public static final int STYLE_3DLEGOPLOT = 3;
    public static final int STYLE_3DSURFACEPLOT = 4;
    public static final int COLORMAP_WARM = 0;
    public static final int COLORMAP_COOL = 1;
    public static final int COLORMAP_THERMAL = 2;
    public static final int COLORMAP_RAINBOW = 3;
    public static final int COLORMAP_GRAYSCALE = 4;
    public static final int COLORMAP_USERDEFINED = 5;
    static final Color[] lineColors = new Color[]{Color.blue, Color.red, Color.darkGray, new Color(0, 145, 0)};
    static final Color[] overflowColors = new Color[lineColors.length];
    static int n;
    static final int[] histStyles;
    static final int[] colorMapSchemes;
    private boolean showZeroHeightBins = true;
    private int m2D_dataHistStyles;
    private int m2D_dataColorMapScheme;
    private Color m2D_shapeColor;
    private Color m2D_overFlowBinColor;
    private Color m2D_startDataColor;
    private Color m2D_endDataColor;
    private boolean m2D_dataOverFlow;
    private boolean m2D_dataShowPlot;
    private boolean m2D_invertColorRange;
    private boolean m2d_logZ;
    static final long serialVersionUID = 5704864807779848936L;

    static final int getHistStyle(String s) {
        if (s.equals("STYLE_BOX")) {
            return 0;
        }
        if (s.equals("STYLE_ELLIPSE")) {
            return 1;
        }
        if (s.equals("STYLE_COLORMAP")) {
            return 2;
        }
        System.out.println("Unrecognized style " + s + ". Using STYLE_BOX instead.");
        return 0;
    }

    static final int getColorMapScheme(String s) {
        if (s.equals("COLORMAP_WARM")) {
            return 0;
        }
        if (s.equals("COLORMAP_COOL")) {
            return 1;
        }
        if (s.equals("COLORMAP_THERMAL")) {
            return 2;
        }
        if (s.equals("COLORMAP_RAINBOW")) {
            return 3;
        }
        if (s.equals("COLORMAP_GRAYSCALE")) {
            return 4;
        }
        if (s.equals("COLORMAP_USERDEFINED")) {
            return 5;
        }
        System.out.println("Unrecognized color map " + s + ". Using COLORMAP_WARM instead.");
        return 0;
    }

    static final String getHistStyleName(int num) {
        String[] histStyleNames = new String[]{"STYLE_BOX", "STYLE_ELLIPSE", "STYLE_COLORMAP"};
        return histStyleNames[num];
    }

    static final String getColorMapSchemeName(int num) {
        String[] colorMapSchemeNames = new String[]{"COLORMAP_WARM", "COLORMAP_COOL", "COLORMAP_THERMAL", "COLORMAP_RAINBOW", "COLORMAP_GRAYSCALE", "COLORMAP_USERDEFINED"};
        return colorMapSchemeNames[num];
    }

    public JASHist2DHistogramStyle() {
        this.initTransientData();
        this.m2D_dataOverFlow = false;
        this.m2D_dataHistStyles = histStyles[0];
        this.m2D_dataColorMapScheme = colorMapSchemes[0];
        this.m2D_shapeColor = lineColors[n];
        this.m2D_overFlowBinColor = overflowColors[n++];
        if (n == lineColors.length) {
            n = 0;
        }
        this.m2D_startDataColor = new Color(255, 255, 255);
        this.m2D_endDataColor = new Color(0, 0, 0);
        this.m2D_dataShowPlot = true;
    }

    public int getHistStyle() {
        return this.m2D_dataHistStyles;
    }

    public void setHistStyle(int nNewValue) {
        this.m2D_dataHistStyles = nNewValue;
        this.changeNotify();
    }

    public int getColorMapScheme() {
        return this.m2D_dataColorMapScheme;
    }

    public void setColorMapScheme(int nNewValue) {
        this.m2D_dataColorMapScheme = nNewValue;
        this.changeNotify();
    }

    public Color getShapeColor() {
        return this.m2D_shapeColor;
    }

    public void setShapeColor(Color nNewValue) {
        this.m2D_shapeColor = nNewValue;
        this.changeNotify();
    }

    public Color getOverflowBinColor() {
        return this.m2D_overFlowBinColor;
    }

    public void setOverflowBinColor(Color nNewValue) {
        this.m2D_overFlowBinColor = nNewValue;
        this.changeNotify();
    }

    public Color getStartDataColor() {
        return this.m2D_startDataColor;
    }

    public void setStartDataColor(Color nNewValue) {
        this.m2D_startDataColor = nNewValue;
        this.changeNotify();
    }

    public Color getEndDataColor() {
        return this.m2D_endDataColor;
    }

    public void setEndDataColor(Color nNewValue) {
        this.m2D_endDataColor = nNewValue;
        this.changeNotify();
    }

    public boolean getShowOverflow() {
        return this.m2D_dataOverFlow;
    }

    public void setShowOverflow(boolean bNewValue) {
        this.m2D_dataOverFlow = bNewValue;
        this.changeNotify();
    }

    public boolean getLogZ() {
        return this.m2d_logZ;
    }

    public void setLogZ(boolean log) {
        this.m2d_logZ = log;
        this.changeNotify();
    }

    public boolean getShowPlot() {
        return this.m2D_dataShowPlot;
    }

    public void setShowPlot(boolean bNewValue) {
        this.m2D_dataShowPlot = bNewValue;
        this.changeNotify();
    }

    public boolean getShowZeroHeightBins() {
        return this.showZeroHeightBins;
    }

    public void setShowZeroHeightBins(boolean show) {
        this.showZeroHeightBins = show;
    }

    protected void changeNotify() {
        super.changeNotify();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initTransientData();
    }

    private void initTransientData() {
    }

    static {
        for (int i = 0; i < lineColors.length; ++i) {
            JASHist2DHistogramStyle.overflowColors[i] = lineColors[i].darker();
        }
        n = 0;
        histStyles = new int[]{0, 1, 2};
        colorMapSchemes = new int[]{0, 1, 2, 3, 4, 5};
    }
}

