/*
 * Decompiled with CFR 0.152.
 */
package outils;

import ihm.FenetreErreur;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.xml.sax.SAXException;

public class XML {
    private org.w3c.dom.Element nroot;
    private Element racine = new Element("dyn");
    private Document document = new Document(this.racine);
    private String m_path;

    public XML(String path) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.m_path = path;
            org.w3c.dom.Document doc = builder.parse(new File(path));
            this.nroot = doc.getDocumentElement();
        }
        catch (Exception e) {
            new FenetreErreur(e + "\n" + path);
        }
    }

    public void reload(String path) {
        try {
            this.racine = new Element("dyn");
            this.document = new Document(this.racine);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.m_path = path;
            org.w3c.dom.Document doc = builder.parse(new File(path));
            this.nroot = doc.getDocumentElement();
        }
        catch (Exception e) {
            new FenetreErreur(e + "\n" + path);
        }
    }

    public String searchByNom(String nom) {
        int i = 0;
        while (i < this.getNbBalise("langue")) {
            if (this.nroot.getElementsByTagName("nom").item(i).getTextContent().compareTo(nom) == 0) {
                return this.nroot.getElementsByTagName("id").item(i).getTextContent();
            }
            ++i;
        }
        return null;
    }

    public void setDefaut(String id) throws Exception {
        this.racine.removeContent();
        this.racine.setAttribute(new Attribute("defaut", id));
        Element debug = new Element("debug");
        debug.setText(this.getElement("debug"));
        this.racine.addContent(debug);
        int i = 0;
        while (i < this.getNbBalise("langue")) {
            Element lang = new Element("langue");
            Element m_id = new Element("id");
            Element m_nom = new Element("nom");
            m_id.setText(this.getElement("id", i));
            m_nom.setText(this.getElement("nom", i));
            lang.addContent(m_id);
            lang.addContent(m_nom);
            this.racine.addContent(lang);
            ++i;
        }
        this.enregistre(this.m_path);
    }

    public String getDefaut() {
        return this.nroot.getAttribute("defaut");
    }

    public String getElement(String balise, int index) {
        try {
            return this.nroot.getElementsByTagName(balise).item(index).getLastChild().getTextContent();
        }
        catch (Exception e) {
            new FenetreErreur("Erreur pour \"" + balise + "\" :\n" + e);
            return "erreur";
        }
    }

    public String getElement(String balise) {
        try {
            return this.nroot.getElementsByTagName(balise).item(0).getTextContent();
        }
        catch (Exception e) {
            new FenetreErreur("Erreur pour retrouver l'item de texte \"" + balise + "\" :\n" + e);
            return "balise";
        }
    }

    public int getNbBalise(String balise) {
        return this.nroot.getElementsByTagName(balise).getLength();
    }

    private void enregistre(String fichier) throws FileNotFoundException, IOException {
        XMLOutputter sortie = new XMLOutputter();
        sortie.output(this.document, (OutputStream)new FileOutputStream(fichier));
    }

    public String getLangueDefaut() {
        String resultat = "";
        try {
            XPathFactory fabrique = XPathFactory.newInstance();
            XPath environnement = fabrique.newXPath();
            XPathExpression expression = environnement.compile("//langue[child::id=/dyn/attribute::defaut]/nom");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            org.w3c.dom.Document doc = builder.parse(new File(this.m_path));
            org.w3c.dom.Element root = doc.getDocumentElement();
            resultat = expression.evaluate(root);
        }
        catch (XPathExpressionException e) {
            new FenetreErreur(e);
        }
        catch (ParserConfigurationException e) {
            new FenetreErreur(e);
        }
        catch (SAXException e) {
            new FenetreErreur(e);
        }
        catch (IOException e) {
            new FenetreErreur(e);
        }
        return resultat;
    }

    public boolean adjectifsAvant() {
        return this.getElement("adjectifs").equals("avant");
    }
}

