/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.util;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.io.File;
import java.io.IOException;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.plot.util.SimpleFrame;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.urls.StandardXYURLGenerator;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class SimpleXYChart {
    private JFreeChart chart;
    private SimpleFrame frame = null;
    public static final Shape TRIANGLE_UP;
    public static final Shape TRIANGLE_RIGHT;
    public static final Shape VECTOR_HEAD;
    public static final Shape DIAMOND;
    public static final Shape SQUARE;
    public static final Shape CIRCLE;

    static {
        int[] xpoints = null;
        int[] ypoints = null;
        double size = 4.0;
        double delta = size / 2.0;
        xpoints = SimpleXYChart.intArray(0.0, delta * 1.5, -delta * 1.5);
        ypoints = SimpleXYChart.intArray(-delta * 1.5, delta * 1.5, delta * 1.5);
        TRIANGLE_UP = new Polygon(xpoints, ypoints, 3);
        xpoints = SimpleXYChart.intArray(-delta, delta, -delta);
        ypoints = SimpleXYChart.intArray(-delta, 0.0, delta);
        TRIANGLE_RIGHT = new Polygon(xpoints, ypoints, 3);
        xpoints = SimpleXYChart.intArray(0.0, delta * 1.7, 0.0, -delta * 1.7);
        ypoints = SimpleXYChart.intArray(-delta * 1.7, 0.0, delta * 1.7, 0.0);
        DIAMOND = new Polygon(xpoints, ypoints, 4);
        double dBIG = delta * 1.5;
        xpoints = SimpleXYChart.intArray(-dBIG, dBIG, -dBIG);
        ypoints = SimpleXYChart.intArray(-dBIG, 0.0, dBIG);
        VECTOR_HEAD = new Polygon(xpoints, ypoints, 3);
        xpoints = SimpleXYChart.intArray(-delta, delta, delta, -delta);
        ypoints = SimpleXYChart.intArray(-delta, -delta, delta, delta);
        SQUARE = new Polygon(xpoints, ypoints, 4);
        int iNbrPoints = 9;
        xpoints = new int[iNbrPoints];
        ypoints = new int[iNbrPoints];
        int i = 0;
        while (i < iNbrPoints) {
            double dAngle = Math.PI * 2 / (double)iNbrPoints * (double)i;
            xpoints[i] = (int)(delta * 1.3 * Math.cos(dAngle));
            ypoints[i] = (int)(delta * 1.3 * Math.sin(dAngle));
            ++i;
        }
        CIRCLE = new Polygon(xpoints, ypoints, iNbrPoints);
    }

    public SimpleXYChart() {
        this.init();
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    private void init() {
        String strTitle = "";
        String strXLabel = "";
        String strYLabel = "";
        XYDataset colxn = null;
        this.chart = SimpleXYChart.createLineShapePlot(strTitle, strXLabel, strYLabel, colxn, PlotOrientation.VERTICAL, false, false, false);
        this.chart.setBackgroundPaint(Color.WHITE);
    }

    public void plot(double[] x, double[] y) {
        if (x == null || y == null) {
            throw new IllegalArgumentException("Valid X and Y arrays should be provided");
        }
        if (x.length != y.length) {
            throw new IllegalArgumentException("X and Y should be of the same length");
        }
        XYPlot plot = this.chart.getXYPlot();
        XYSeriesCollection colxn = (XYSeriesCollection)plot.getDataset();
        if (colxn == null) {
            colxn = new XYSeriesCollection();
        }
        int iNbrSeries = colxn.getSeriesCount() - 1 + 1;
        XYSeries data = new XYSeries((Comparable)((Object)("Series " + iNbrSeries)), false, true);
        int iEntries = x.length;
        int i = 0;
        while (i < iEntries) {
            data.add(x[i], y[i]);
            ++i;
        }
        colxn.addSeries(data);
        plot.setDataset(colxn);
    }

    public void plot(double[] x, double[] y, String label) {
        this.plot(x, y, null, null, label);
    }

    public void plot(double[] x, double[] y, Paint paint) {
        this.plot(x, y, paint, null, null);
    }

    public void plot(double[] x, double[] y, Paint paint, String label) {
        this.plot(x, y, paint, null, label);
    }

    public void plot(double[] x, double[] y, Paint paint, Shape shape) {
        this.plot(x, y, paint, shape, false, null);
    }

    public void plot(double[] x, double[] y, Paint paint, Shape shape, String label) {
        this.plot(x, y, paint, shape, false, label);
    }

    public void plot(double[] x, double[] y, Paint paint, Shape shape, boolean withoutLines, String label) {
        StandardXYItemRenderer renderer;
        if (x == null || y == null) {
            throw new IllegalArgumentException("Valid X and Y arrays should be provided");
        }
        if (x.length != y.length) {
            throw new IllegalArgumentException("X and Y should be of the same length");
        }
        if (label == null) {
            label = "{Unlabelled}";
        }
        XYSeries data = new XYSeries((Comparable)((Object)label), false, true);
        int iEntries = x.length;
        int i = 0;
        while (i < iEntries) {
            data.add(x[i], y[i]);
            ++i;
        }
        if (shape == null) {
            renderer = new StandardXYItemRenderer(2);
        } else {
            renderer = withoutLines ? new StandardXYItemRenderer(1) : new StandardXYItemRenderer(3);
            renderer.setShape(shape);
        }
        renderer.setShapesFilled(true);
        renderer.setPaint(paint);
        XYPlot plot = this.chart.getXYPlot();
        int iNbrSeries = plot.getDatasetCount();
        int iNewSeries = iNbrSeries + 1;
        plot.setRenderer(iNewSeries, renderer);
        plot.setDataset(iNewSeries, new XYSeriesCollection(data));
    }

    public void setTitle(String title) {
        this.chart.setTitle(title);
        if (this.frame != null) {
            this.frame.setTitle(title);
        }
    }

    public void setXLabel(String label) {
        XYPlot plot = (XYPlot)this.chart.getPlot();
        plot.getDomainAxis().setLabel(label);
    }

    public void setYLabel(String label) {
        XYPlot plot = (XYPlot)this.chart.getPlot();
        plot.getRangeAxis().setLabel(label);
    }

    public synchronized SimpleFrame getSimpleFrame() {
        if (this.frame == null) {
            this.frame = new SimpleFrame(this.chart);
        }
        return this.frame;
    }

    public synchronized void display() {
        SimpleFrame frame = this.getSimpleFrame();
        frame.setVisible(true);
        frame.setTitle(this.chart.getTitle().getText());
    }

    public void saveAs(String fileName) throws IOException {
        File file = new File(fileName);
        ChartUtilities.saveChartAsPNG(file, this.chart, 600, 400);
    }

    public void plot(double[] x1, double[] y1, double[] x2, double[] y2) {
        if (x1 == null || y1 == null) {
            throw new IllegalArgumentException("Valid X and Y arrays should be provided");
        }
        if (x2 == null || y2 == null) {
            throw new IllegalArgumentException("Valid X and Y arrays should be provided");
        }
        if (x1.length != y1.length) {
            throw new IllegalArgumentException("X and Y should be of the same length");
        }
        if (x2.length != y2.length) {
            throw new IllegalArgumentException("X and Y should be of the same length");
        }
        XYSeriesCollection colxn = new XYSeriesCollection();
        XYSeries data1 = new XYSeries((Comparable)((Object)"Series 1"), false, true);
        int iEntries = x1.length;
        int i = 0;
        while (i < iEntries) {
            data1.add(x1[i], y1[i]);
            ++i;
        }
        colxn.addSeries(data1);
        XYSeries data2 = new XYSeries((Comparable)((Object)"Series 2"), false, true);
        iEntries = x2.length;
        int i2 = 0;
        while (i2 < iEntries) {
            data2.add(x2[i2], y2[i2]);
            ++i2;
        }
        colxn.addSeries(data2);
        XYPlot plot = (XYPlot)this.chart.getPlot();
        plot.setDataset(colxn);
    }

    public void grid(boolean status) {
        XYPlot plot = (XYPlot)this.chart.getPlot();
        plot.setRangeGridlinesVisible(status);
        plot.setDomainGridlinesVisible(status);
    }

    public void axis(boolean status) {
        XYPlot plot = (XYPlot)this.chart.getPlot();
        plot.getDomainAxis().setVisible(status);
        plot.getRangeAxis().setVisible(status);
    }

    public void legend(boolean status) {
        if (status) {
            this.chart.addLegend(new LegendTitle(this.chart.getPlot()));
        } else {
            this.chart.addLegend(null);
        }
    }

    private static int[] intArray(double a, double b, double c, double d) {
        return new int[]{(int)a, (int)b, (int)c, (int)d};
    }

    private static int[] intArray(double a, double b, double c) {
        return new int[]{(int)a, (int)b, (int)c};
    }

    private static int[] intArray(double[] data) {
        int iNbrPoints = data.length;
        int[] iAryPoints = new int[iNbrPoints];
        int i = 0;
        while (i < iNbrPoints) {
            int iData;
            double dData = data[i];
            iAryPoints[i] = iData = (int)dData;
            ++i;
        }
        return iAryPoints;
    }

    private static XY rotate(XY data, double angle) {
        angle = -angle;
        double dX = data.x * Math.cos(angle) - data.y * Math.sin(angle);
        double dY = data.x * Math.sin(angle) + data.y * Math.cos(angle);
        return new XY(dX, dY);
    }

    public static Shape createShape(double[] aryX, double[] aryY, double angle) {
        if (aryX == null || aryY == null) {
            throw new IllegalArgumentException("Valid arrays of data must be provided");
        }
        int iNbrPoints = aryX.length;
        if (iNbrPoints != aryY.length) {
            throw new IllegalArgumentException("Both arrays must be of the same length");
        }
        double[] dAryX = new double[iNbrPoints];
        double[] dAryY = new double[iNbrPoints];
        int i = 0;
        while (i < iNbrPoints) {
            XY data = new XY(aryX[i], aryY[i]);
            XY dataRotated = SimpleXYChart.rotate(data, angle);
            dAryX[i] = dataRotated.x;
            dAryY[i] = dataRotated.y;
            ++i;
        }
        int[] xpoints = SimpleXYChart.intArray(dAryX);
        int[] ypoints = SimpleXYChart.intArray(dAryY);
        Polygon shape = new Polygon(xpoints, ypoints, iNbrPoints);
        return shape;
    }

    protected static JFreeChart createLineShapePlot(String title, String xAxisLabel, String yAxisLabel, XYDataset data, PlotOrientation orientation, boolean legend, boolean tooltips, boolean urls) {
        NumberAxis xAxis = new NumberAxis(xAxisLabel);
        xAxis.setAutoRangeIncludesZero(false);
        NumberAxis yAxis = new NumberAxis(yAxisLabel);
        yAxis.setAutoRangeIncludesZero(false);
        XYPlot plot = new XYPlot(data, xAxis, yAxis, null);
        StandardXYToolTipGenerator toolTipGenerator = null;
        if (tooltips) {
            toolTipGenerator = new StandardXYToolTipGenerator();
        }
        StandardXYURLGenerator urlGenerator = null;
        if (urls) {
            urlGenerator = new StandardXYURLGenerator();
        }
        StandardXYItemRenderer renderer = new StandardXYItemRenderer(3, toolTipGenerator, urlGenerator);
        renderer.setShapesFilled(Boolean.TRUE);
        plot.setRenderer(renderer);
        plot.setOrientation(orientation);
        JFreeChart chart = new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, plot, legend);
        return chart;
    }

    public void clearPlot() {
        XYPlot plot = this.chart.getXYPlot();
        XYSeriesCollection colxn = (XYSeriesCollection)plot.getDataset();
        if (colxn != null) {
            colxn.removeAllSeries();
        }
    }

    private static class XY {
        public double x;
        public double y;

        public XY() {
        }

        public XY(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }
}

