/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import drawing.Canvas;
import drawing.SelectZone;
import ihm.FenetreErreur;
import ihm.FenetreHabillage;
import ihm.FenetreProprietes;
import ihm.Gestionnaire;
import ihm.IHM;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.EventListener;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.EventListenerList;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.emf.EMFGraphics2D;
import org.freehep.graphicsio.pdf.PDFGraphics2D;
import org.freehep.graphicsio.svg.SVGGraphics2D;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYIDAnnotation;
import org.jfree.chart.annotations.XYLineAnnotation;
import org.jfree.chart.editor.ChartEditor;
import org.jfree.chart.editor.ChartEditorManager;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.chart.event.ChartProgressEvent;
import org.jfree.chart.event.ChartProgressListener;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.plot.Zoomable;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.ui.ExtensionFileFilter;

public class ChartPanel
extends JPanel
implements ChartChangeListener,
ChartProgressListener,
ActionListener,
MouseListener,
MouseMotionListener,
Printable,
Serializable {
    private static final long serialVersionUID = 6046366297214274674L;
    public static final boolean DEFAULT_BUFFER_USED = false;
    public static final int DEFAULT_WIDTH = 680;
    public static final int DEFAULT_HEIGHT = 420;
    public static final int DEFAULT_MINIMUM_DRAW_WIDTH = 300;
    public static final int DEFAULT_MINIMUM_DRAW_HEIGHT = 200;
    public static final int DEFAULT_MAXIMUM_DRAW_WIDTH = 800;
    public static final int DEFAULT_MAXIMUM_DRAW_HEIGHT = 600;
    public static final int DEFAULT_ZOOM_TRIGGER_DISTANCE = 10;
    public static final String PROPERTIES_COMMAND = "PROPERTIES";
    public static final String SAVE_COMMAND = "SAVE";
    public static final String PRINT_COMMAND = "PRINT";
    public static final String ZOOM_IN_BOTH_COMMAND = "ZOOM_IN_BOTH";
    public static final String ZOOM_IN_DOMAIN_COMMAND = "ZOOM_IN_DOMAIN";
    public static final String ZOOM_IN_RANGE_COMMAND = "ZOOM_IN_RANGE";
    public static final String ZOOM_OUT_BOTH_COMMAND = "ZOOM_OUT_BOTH";
    public static final String ZOOM_OUT_DOMAIN_COMMAND = "ZOOM_DOMAIN_BOTH";
    public static final String ZOOM_OUT_RANGE_COMMAND = "ZOOM_RANGE_BOTH";
    public static final String ZOOM_RESET_BOTH_COMMAND = "ZOOM_RESET_BOTH";
    public static final String ZOOM_RESET_DOMAIN_COMMAND = "ZOOM_RESET_DOMAIN";
    public static final String ZOOM_RESET_RANGE_COMMAND = "ZOOM_RESET_RANGE";
    private static final String HABILLAGE_COMMAND = "HABILLAGE";
    private JFreeChart chart;
    private EventListenerList chartMouseListeners;
    private boolean useBuffer;
    private boolean refreshBuffer;
    private Image chartBuffer;
    private int chartBufferHeight;
    private int chartBufferWidth;
    private int minimumDrawWidth;
    private int minimumDrawHeight;
    private int maximumDrawWidth;
    private int maximumDrawHeight;
    private JPopupMenu popup;
    private ChartRenderingInfo info;
    private Point2D anchor;
    private double scaleX;
    private double scaleY;
    private PlotOrientation orientation = PlotOrientation.VERTICAL;
    private boolean domainZoomable = false;
    private boolean rangeZoomable = false;
    private Point zoomPoint = null;
    private transient Rectangle2D zoomRectangle = null;
    private Point selectPoint = null;
    private transient Rectangle2D selectRectangle = null;
    private boolean fillZoomRectangle = false;
    private int zoomTriggerDistance;
    private boolean horizontalAxisTrace = false;
    private boolean verticalAxisTrace = false;
    private transient Line2D verticalTraceLine;
    private transient Line2D horizontalTraceLine;
    private JMenuItem zoomInBothMenuItem;
    private JMenuItem zoomInDomainMenuItem;
    private JMenuItem zoomInRangeMenuItem;
    private JMenuItem zoomOutBothMenuItem;
    private JMenuItem zoomOutDomainMenuItem;
    private JMenuItem zoomOutRangeMenuItem;
    private JMenuItem zoomResetBothMenuItem;
    private JMenuItem zoomResetDomainMenuItem;
    private JMenuItem zoomResetRangeMenuItem;
    private boolean enforceFileExtensions;
    private boolean ownToolTipDelaysActive;
    private int originalToolTipInitialDelay;
    private int originalToolTipReshowDelay;
    private int originalToolTipDismissDelay;
    private int ownToolTipInitialDelay;
    private int ownToolTipReshowDelay;
    private int ownToolTipDismissDelay;
    private double zoomInFactor = 0.5;
    private double zoomOutFactor = 2.0;
    private boolean isMoove = false;
    private boolean ClickRight;
    private Canvas m_canvas = null;
    private Gestionnaire m_gestionnaire;
    private XYLineAnnotation m_line = null;
    private int saveIndexAnnot = -1;
    private SelectZone sel = null;
    private double saveDecalageX;
    private double saveDecalageY;

    public void setCanvas(Canvas canvas) {
        this.m_canvas = canvas;
    }

    public Canvas getCanvas() {
        return this.m_canvas;
    }

    public void setGestionnaire(Gestionnaire gest) {
        this.m_gestionnaire = gest;
    }

    public Gestionnaire getGestionnaire() {
        return this.m_gestionnaire;
    }

    public void setLine(XYLineAnnotation line) {
        this.m_line = line;
    }

    public XYLineAnnotation getLine() {
        return this.m_line;
    }

    public SelectZone getSelection() {
        return this.sel;
    }

    public ChartPanel(JFreeChart chart, Canvas canvas) {
        this(chart, 680, 420, 300, 200, 800, 600, false, true, true, true, true, true, canvas);
    }

    public ChartPanel(JFreeChart chart) {
        this(chart, 680, 420, 300, 200, 800, 600, false, true, true, true, true, true, null);
    }

    public ChartPanel(JFreeChart chart, boolean useBuffer) {
        this(chart, 680, 420, 300, 200, 800, 600, useBuffer, true, true, true, true, true, null);
    }

    public ChartPanel(JFreeChart chart, boolean properties, boolean save, boolean print, boolean zoom, boolean tooltips) {
        this(chart, 680, 420, 300, 200, 800, 600, false, properties, save, print, zoom, tooltips, null);
    }

    public ChartPanel(JFreeChart chart, int width, int height, int minimumDrawWidth, int minimumDrawHeight, int maximumDrawWidth, int maximumDrawHeight, boolean useBuffer, boolean properties, boolean save, boolean print, boolean zoom, boolean tooltips, Canvas canvas) {
        this.setChart(chart);
        this.chartMouseListeners = new EventListenerList();
        this.info = new ChartRenderingInfo();
        this.setPreferredSize(new Dimension(width, height));
        this.useBuffer = useBuffer;
        this.refreshBuffer = false;
        this.minimumDrawWidth = minimumDrawWidth;
        this.minimumDrawHeight = minimumDrawHeight;
        this.maximumDrawWidth = maximumDrawWidth;
        this.maximumDrawHeight = maximumDrawHeight;
        this.zoomTriggerDistance = 10;
        this.popup = null;
        if (properties || save || print || zoom) {
            this.popup = this.createPopupMenu(properties, save, print, zoom);
        }
        this.enableEvents(16L);
        this.enableEvents(32L);
        this.setDisplayToolTips(tooltips);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.enforceFileExtensions = true;
        ToolTipManager ttm = ToolTipManager.sharedInstance();
        this.ownToolTipInitialDelay = ttm.getInitialDelay();
        this.ownToolTipDismissDelay = ttm.getDismissDelay();
        this.ownToolTipReshowDelay = ttm.getReshowDelay();
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public void setChart(JFreeChart chart) {
        if (this.chart != null) {
            this.chart.removeChangeListener(this);
            this.chart.removeProgressListener(this);
        }
        this.chart = chart;
        if (chart != null) {
            this.chart.addChangeListener(this);
            this.chart.addProgressListener(this);
            Plot plot = chart.getPlot();
            this.domainZoomable = false;
            this.rangeZoomable = false;
            if (plot instanceof Zoomable) {
                Zoomable z = (Zoomable)((Object)plot);
                this.domainZoomable = z.isDomainZoomable();
                this.rangeZoomable = z.isRangeZoomable();
                this.orientation = z.getOrientation();
            }
        } else {
            this.domainZoomable = false;
            this.rangeZoomable = false;
        }
        if (this.useBuffer) {
            this.refreshBuffer = true;
        }
        this.repaint();
    }

    public int getMinimumDrawWidth() {
        return this.minimumDrawWidth;
    }

    public void setMinimumDrawWidth(int width) {
        this.minimumDrawWidth = width;
    }

    public int getMaximumDrawWidth() {
        return this.maximumDrawWidth;
    }

    public void setMaximumDrawWidth(int width) {
        this.maximumDrawWidth = width;
    }

    public int getMinimumDrawHeight() {
        return this.minimumDrawHeight;
    }

    public void setMinimumDrawHeight(int height) {
        this.minimumDrawHeight = height;
    }

    public int getMaximumDrawHeight() {
        return this.maximumDrawHeight;
    }

    public void setMaximumDrawHeight(int height) {
        this.maximumDrawHeight = height;
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public Point2D getAnchor() {
        return this.anchor;
    }

    protected void setAnchor(Point2D anchor) {
        this.anchor = anchor;
    }

    public JPopupMenu getPopupMenu() {
        return this.popup;
    }

    public void setPopupMenu(JPopupMenu popup) {
        this.popup = popup;
    }

    public ChartRenderingInfo getChartRenderingInfo() {
        return this.info;
    }

    public void setMouseZoomable(boolean flag) {
        this.setMouseZoomable(flag, true);
    }

    public void setMouseZoomable(boolean flag, boolean fillRectangle) {
        this.setDomainZoomable(flag);
        this.setRangeZoomable(flag);
        this.setFillZoomRectangle(fillRectangle);
    }

    public boolean isDomainZoomable() {
        return this.domainZoomable;
    }

    public void setDomainZoomable(boolean flag) {
        if (flag) {
            Plot plot = this.chart.getPlot();
            if (plot instanceof Zoomable) {
                Zoomable z = (Zoomable)((Object)plot);
                this.domainZoomable = flag && z.isDomainZoomable();
            }
        } else {
            this.domainZoomable = false;
        }
    }

    public boolean isRangeZoomable() {
        return this.rangeZoomable;
    }

    public void setRangeZoomable(boolean flag) {
        if (flag) {
            Plot plot = this.chart.getPlot();
            if (plot instanceof Zoomable) {
                Zoomable z = (Zoomable)((Object)plot);
                this.rangeZoomable = flag && z.isRangeZoomable();
            }
        } else {
            this.rangeZoomable = false;
        }
    }

    public boolean getFillZoomRectangle() {
        return this.fillZoomRectangle;
    }

    public void setFillZoomRectangle(boolean flag) {
        this.fillZoomRectangle = flag;
    }

    public int getZoomTriggerDistance() {
        return this.zoomTriggerDistance;
    }

    public void setZoomTriggerDistance(int distance) {
        this.zoomTriggerDistance = distance;
    }

    public boolean getHorizontalAxisTrace() {
        return this.horizontalAxisTrace;
    }

    public void setHorizontalAxisTrace(boolean flag) {
        this.horizontalAxisTrace = flag;
    }

    protected Line2D getHorizontalTraceLine() {
        return this.horizontalTraceLine;
    }

    protected void setHorizontalTraceLine(Line2D line) {
        this.horizontalTraceLine = line;
    }

    public boolean getVerticalAxisTrace() {
        return this.verticalAxisTrace;
    }

    public void setVerticalAxisTrace(boolean flag) {
        this.verticalAxisTrace = flag;
    }

    protected Line2D getVerticalTraceLine() {
        return this.verticalTraceLine;
    }

    protected void setVerticalTraceLine(Line2D line) {
        this.verticalTraceLine = line;
    }

    public boolean isEnforceFileExtensions() {
        return this.enforceFileExtensions;
    }

    public void setEnforceFileExtensions(boolean enforce) {
        this.enforceFileExtensions = enforce;
    }

    public void setDisplayToolTips(boolean flag) {
        if (flag) {
            ToolTipManager.sharedInstance().registerComponent(this);
        } else {
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }
    }

    public String getToolTipText(MouseEvent e) {
        EntityCollection entities;
        String result = null;
        if (this.info != null && (entities = this.info.getEntityCollection()) != null) {
            Insets insets = this.getInsets();
            ChartEntity entity = entities.getEntity((int)((double)(e.getX() - insets.left) / this.scaleX), (int)((double)(e.getY() - insets.top) / this.scaleY));
            if (entity != null) {
                result = entity.getToolTipText();
            }
        }
        return result;
    }

    public Point translateJava2DToScreen(Point2D java2DPoint) {
        Insets insets = this.getInsets();
        int x = (int)(java2DPoint.getX() * this.scaleX + (double)insets.left);
        int y = (int)(java2DPoint.getY() * this.scaleY + (double)insets.top);
        return new Point(x, y);
    }

    public Point2D translateScreenToJava2D(Point screenPoint) {
        Insets insets = this.getInsets();
        double x = (screenPoint.getX() - (double)insets.left) / this.scaleX;
        double y = (screenPoint.getY() - (double)insets.top) / this.scaleY;
        return new Point2D.Double(x, y);
    }

    public Rectangle2D scale(Rectangle2D rect) {
        Insets insets = this.getInsets();
        double x = rect.getX() * this.getScaleX() + (double)insets.left;
        double y = rect.getY() * this.getScaleY() + (double)insets.top;
        double w = rect.getWidth() * this.getScaleX();
        double h = rect.getHeight() * this.getScaleY();
        return new Rectangle2D.Double(x, y, w, h);
    }

    public ChartEntity getEntityForPoint(int viewX, int viewY) {
        ChartEntity result = null;
        if (this.info != null) {
            Insets insets = this.getInsets();
            double x = (double)(viewX - insets.left) / this.scaleX;
            double y = (double)(viewY - insets.top) / this.scaleY;
            EntityCollection entities = this.info.getEntityCollection();
            result = entities != null ? entities.getEntity(x, y) : null;
        }
        return result;
    }

    public boolean getRefreshBuffer() {
        return this.refreshBuffer;
    }

    public void setRefreshBuffer(boolean flag) {
        this.refreshBuffer = flag;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.chart == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        Rectangle2D.Double available = new Rectangle2D.Double(insets.left, insets.top, size.getWidth() - (double)insets.left - (double)insets.right, size.getHeight() - (double)insets.top - (double)insets.bottom);
        boolean scale = false;
        double drawWidth = ((RectangularShape)available).getWidth();
        double drawHeight = ((RectangularShape)available).getHeight();
        this.scaleX = 1.0;
        this.scaleY = 1.0;
        if (drawWidth < (double)this.minimumDrawWidth) {
            this.scaleX = drawWidth / (double)this.minimumDrawWidth;
            drawWidth = this.minimumDrawWidth;
            scale = true;
        } else if (drawWidth > (double)this.maximumDrawWidth) {
            this.scaleX = drawWidth / (double)this.maximumDrawWidth;
            drawWidth = this.maximumDrawWidth;
            scale = true;
        }
        if (drawHeight < (double)this.minimumDrawHeight) {
            this.scaleY = drawHeight / (double)this.minimumDrawHeight;
            drawHeight = this.minimumDrawHeight;
            scale = true;
        } else if (drawHeight > (double)this.maximumDrawHeight) {
            this.scaleY = drawHeight / (double)this.maximumDrawHeight;
            drawHeight = this.maximumDrawHeight;
            scale = true;
        }
        Rectangle2D.Double chartArea = new Rectangle2D.Double(0.0, 0.0, drawWidth, drawHeight);
        if (this.useBuffer) {
            if (this.chartBuffer == null || (double)this.chartBufferWidth != ((RectangularShape)available).getWidth() || (double)this.chartBufferHeight != ((RectangularShape)available).getHeight()) {
                this.chartBufferWidth = (int)((RectangularShape)available).getWidth();
                this.chartBufferHeight = (int)((RectangularShape)available).getHeight();
                this.chartBuffer = this.createImage(this.chartBufferWidth, this.chartBufferHeight);
                this.refreshBuffer = true;
            }
            if (this.refreshBuffer) {
                Rectangle2D.Double bufferArea = new Rectangle2D.Double(0.0, 0.0, this.chartBufferWidth, this.chartBufferHeight);
                Graphics2D bufferG2 = (Graphics2D)this.chartBuffer.getGraphics();
                if (scale) {
                    AffineTransform saved = bufferG2.getTransform();
                    AffineTransform st = AffineTransform.getScaleInstance(this.scaleX, this.scaleY);
                    bufferG2.transform(st);
                    this.chart.draw(bufferG2, chartArea, this.anchor, this.info);
                    bufferG2.setTransform(saved);
                } else {
                    this.chart.draw(bufferG2, bufferArea, this.anchor, this.info);
                }
                this.refreshBuffer = false;
            }
            g2.drawImage(this.chartBuffer, insets.left, insets.right, this);
        } else {
            AffineTransform saved = g2.getTransform();
            g2.translate(insets.left, insets.top);
            if (scale) {
                AffineTransform st = AffineTransform.getScaleInstance(this.scaleX, this.scaleY);
                g2.transform(st);
            }
            this.chart.draw(g2, chartArea, this.anchor, this.info);
            g2.setTransform(saved);
        }
        this.drawZoomRectangle(g2);
        g2.dispose();
        this.anchor = null;
        this.verticalTraceLine = null;
        this.horizontalTraceLine = null;
    }

    public void chartChanged(ChartChangeEvent event) {
        this.refreshBuffer = true;
        Plot plot = this.chart.getPlot();
        if (plot instanceof Zoomable) {
            Zoomable z = (Zoomable)((Object)plot);
            this.orientation = z.getOrientation();
        }
        this.repaint();
    }

    public void chartProgress(ChartProgressEvent event) {
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals(PROPERTIES_COMMAND)) {
            new FenetreProprietes(this.getGestionnaire(), this.getChart());
        } else if (command.equals(HABILLAGE_COMMAND)) {
            new FenetreHabillage((Frame)this.getGestionnaire().getIHM(), this.getGestionnaire());
        } else if (command.equals(SAVE_COMMAND)) {
            try {
                this.doSaveAs();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (command.equals(PRINT_COMMAND)) {
            this.createChartPrintJob();
        } else if (command.equals(ZOOM_IN_BOTH_COMMAND)) {
            this.zoomInBoth(this.zoomPoint.getX(), this.zoomPoint.getY());
        } else if (command.equals(ZOOM_IN_DOMAIN_COMMAND)) {
            this.zoomInDomain(this.zoomPoint.getX(), this.zoomPoint.getY());
        } else if (command.equals(ZOOM_IN_RANGE_COMMAND)) {
            this.zoomInRange(this.zoomPoint.getX(), this.zoomPoint.getY());
        } else if (command.equals(ZOOM_OUT_BOTH_COMMAND)) {
            this.zoomOutBoth(this.zoomPoint.getX(), this.zoomPoint.getY());
        } else if (command.equals(ZOOM_OUT_DOMAIN_COMMAND)) {
            this.zoomOutDomain(this.zoomPoint.getX(), this.zoomPoint.getY());
        } else if (command.equals(ZOOM_OUT_RANGE_COMMAND)) {
            this.zoomOutRange(this.zoomPoint.getX(), this.zoomPoint.getY());
        } else if (command.equals(ZOOM_RESET_BOTH_COMMAND)) {
            this.restoreAutoBounds();
        } else if (command.equals(ZOOM_RESET_DOMAIN_COMMAND)) {
            this.restoreAutoDomainBounds();
        } else if (command.equals(ZOOM_RESET_RANGE_COMMAND)) {
            this.restoreAutoRangeBounds();
        }
    }

    public void mouseEntered(MouseEvent e) {
        if (!this.ownToolTipDelaysActive) {
            ToolTipManager ttm = ToolTipManager.sharedInstance();
            this.originalToolTipInitialDelay = ttm.getInitialDelay();
            ttm.setInitialDelay(this.ownToolTipInitialDelay);
            this.originalToolTipReshowDelay = ttm.getReshowDelay();
            ttm.setReshowDelay(this.ownToolTipReshowDelay);
            this.originalToolTipDismissDelay = ttm.getDismissDelay();
            ttm.setDismissDelay(this.ownToolTipDismissDelay);
            this.ownToolTipDelaysActive = true;
        }
    }

    public void mouseExited(MouseEvent e) {
        if (this.ownToolTipDelaysActive) {
            ToolTipManager ttm = ToolTipManager.sharedInstance();
            ttm.setInitialDelay(this.originalToolTipInitialDelay);
            ttm.setReshowDelay(this.originalToolTipReshowDelay);
            ttm.setDismissDelay(this.originalToolTipDismissDelay);
            this.ownToolTipDelaysActive = false;
        }
    }

    public void mousePressed(MouseEvent e) {
        block10: {
            if (SwingUtilities.isLeftMouseButton(e)) {
                this.ClickRight = false;
                XYPlot plot = (XYPlot)this.getChart().getPlot();
                try {
                    Point2D pointChart = this.translateScreenToJava2D(e.getPoint());
                    XYIDAnnotation annot = this.getCanvas().findAnnot(this, pointChart);
                    if (annot != null) {
                        this.isMoove = true;
                        this.saveIndexAnnot = this.getCanvas().indexOfAnnot(annot);
                        this.saveDecalageX = Canvas.java2Dtochart(this, pointChart.getX(), true) - annot.getX();
                        this.saveDecalageY = Canvas.java2Dtochart(this, pointChart.getY(), false) - annot.getY();
                        this.setLine(new XYLineAnnotation(annot.getLblx(), annot.getLbly(), annot.getPtsx(), annot.getPtsy()));
                        AbstractXYItemRenderer renderer = (AbstractXYItemRenderer)plot.getRenderer();
                        renderer.setRearrangementAutorise(false);
                        renderer.addAnnotation(this.getLine());
                        break block10;
                    }
                    this.isMoove = false;
                    if (this.selectRectangle != null) break block10;
                    Rectangle2D screenDataArea = this.getScreenDataArea(e.getX(), e.getY());
                    if (screenDataArea != null) {
                        this.selectPoint = this.getPointInRectangle(e.getX(), e.getY(), screenDataArea);
                        break block10;
                    }
                    this.selectPoint = null;
                }
                catch (Exception err) {
                    new FenetreErreur(err);
                }
            } else if (SwingUtilities.isMiddleMouseButton(e)) {
                this.ClickRight = false;
                if (this.zoomRectangle == null) {
                    Rectangle2D screenDataArea = this.getScreenDataArea(e.getX(), e.getY());
                    this.zoomPoint = screenDataArea != null ? this.getPointInRectangle(e.getX(), e.getY(), screenDataArea) : null;
                    if (e.isPopupTrigger() && this.popup != null) {
                        this.displayPopupMenu(e.getX(), e.getY());
                    }
                }
            } else {
                this.ClickRight = true;
            }
        }
    }

    private Point getPointInRectangle(int x, int y, Rectangle2D area) {
        x = (int)Math.max(Math.ceil(area.getMinX()), Math.min((double)x, Math.floor(area.getMaxX())));
        y = (int)Math.max(Math.ceil(area.getMinY()), Math.min((double)y, Math.floor(area.getMaxY())));
        return new Point(x, y);
    }

    public void mouseDragged(MouseEvent e) {
        try {
            if (!this.ClickRight) {
                if (this.getCanvas() != null && this.getLine() != null) {
                    XYIDAnnotation annot = this.getCanvas().getAnnot(this.saveIndexAnnot);
                    XYPlot plot = (XYPlot)this.chart.getPlot();
                    AbstractXYItemRenderer renderer = (AbstractXYItemRenderer)plot.getRenderer();
                    Point2D p = this.translateScreenToJava2D(e.getPoint());
                    annot.setLblx(Canvas.java2Dtochart(this, p.getX(), true) - this.saveDecalageX);
                    annot.setLbly(Canvas.java2Dtochart(this, p.getY(), false) - this.saveDecalageY);
                    this.setLine(new XYLineAnnotation(annot.getLblx(), annot.getLbly(), annot.getPtsx(), annot.getPtsy()));
                    XYIDAnnotation annot2 = new XYIDAnnotation(annot.getText(), annot.getLblx(), annot.getLbly(), annot.getPtsx(), annot.getPtsy(), annot.getColor());
                    annot2.setFont(annot.getFont());
                    annot2.setTextAnchor(annot.getTextAnchor());
                    this.getCanvas().remplaceAnnot(annot2, this.getCanvas().indexOfAnnot(annot));
                    renderer.removeAnnotations();
                    int i = 0;
                    while (i < this.getCanvas().getVectAnnot().size()) {
                        annot = this.getCanvas().getAnnot(i);
                        annot.setPaint(annot.getColor());
                        renderer.addAnnotation(annot);
                        ++i;
                    }
                    renderer.addAnnotation(this.getLine());
                    if (this.getCanvas().tailleBranche() > 0) {
                        i = 0;
                        while (i < this.getCanvas().tailleBranche()) {
                            renderer.addAnnotation(this.getCanvas().getBranche(i));
                            ++i;
                        }
                    }
                }
                if (this.popup != null && this.popup.isShowing()) {
                    return;
                }
                Graphics2D g2 = (Graphics2D)this.getGraphics();
                if (this.zoomPoint != null) {
                    this.drawZoomRectangle(g2);
                } else if (!this.isMoove) {
                    this.drawSelectRectangle(g2);
                }
                boolean hZoom = false;
                boolean vZoom = false;
                if (this.orientation == PlotOrientation.HORIZONTAL) {
                    hZoom = this.rangeZoomable;
                    vZoom = this.domainZoomable;
                } else {
                    hZoom = this.domainZoomable;
                    vZoom = this.rangeZoomable;
                }
                Rectangle2D scaledDataArea = null;
                if (this.zoomPoint != null) {
                    scaledDataArea = this.getScreenDataArea((int)this.zoomPoint.getX(), (int)this.zoomPoint.getY());
                } else if (!this.isMoove) {
                    scaledDataArea = this.getScreenDataArea((int)this.selectPoint.getX(), (int)this.selectPoint.getY());
                }
                if (hZoom && vZoom) {
                    double xmax = 0.0;
                    double ymax = 0.0;
                    if (this.zoomPoint != null) {
                        xmax = Math.min((double)e.getX(), scaledDataArea.getMaxX());
                        ymax = Math.min((double)e.getY(), scaledDataArea.getMaxY());
                    } else if (!this.isMoove) {
                        xmax = Math.min((double)e.getX(), scaledDataArea.getMaxX());
                        ymax = Math.min((double)e.getY(), scaledDataArea.getMaxY());
                    }
                    if (this.zoomPoint != null) {
                        this.zoomRectangle = new Rectangle2D.Double(this.zoomPoint.getX(), this.zoomPoint.getY(), xmax - this.zoomPoint.getX(), ymax - this.zoomPoint.getY());
                    } else if (!this.isMoove) {
                        this.selectRectangle = new Rectangle2D.Double(this.selectPoint.getX(), this.selectPoint.getY(), xmax - this.selectPoint.getX(), ymax - this.selectPoint.getY());
                    }
                } else if (hZoom) {
                    double xmax = Math.min((double)e.getX(), scaledDataArea.getMaxX());
                    if (this.zoomPoint != null) {
                        this.zoomRectangle = new Rectangle2D.Double(this.zoomPoint.getX(), scaledDataArea.getMinY(), xmax - this.zoomPoint.getX(), scaledDataArea.getHeight());
                    } else if (!this.isMoove) {
                        this.selectRectangle = new Rectangle2D.Double(this.selectPoint.getX(), scaledDataArea.getMinY(), xmax - this.selectPoint.getX(), scaledDataArea.getHeight());
                    }
                } else if (vZoom) {
                    double ymax = Math.min((double)e.getY(), scaledDataArea.getMaxY());
                    if (this.zoomPoint != null) {
                        this.zoomRectangle = new Rectangle2D.Double(scaledDataArea.getMinX(), this.zoomPoint.getY(), scaledDataArea.getWidth(), ymax - this.zoomPoint.getY());
                    } else if (!this.isMoove) {
                        this.selectRectangle = new Rectangle2D.Double(scaledDataArea.getMinX(), this.selectPoint.getY(), scaledDataArea.getWidth(), ymax - this.selectPoint.getY());
                    }
                }
                if (this.zoomPoint != null) {
                    this.drawZoomRectangle(g2);
                }
                if (!this.isMoove) {
                    this.drawSelectRectangle(g2);
                }
                g2.dispose();
            }
        }
        catch (Exception ex) {
            new FenetreErreur(ex);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.getCanvas() != null && this.getLine() != null) {
            XYIDAnnotation annot = this.getCanvas().getAnnot(this.saveIndexAnnot);
            XYPlot plot = (XYPlot)this.chart.getPlot();
            AbstractXYItemRenderer renderer = (AbstractXYItemRenderer)plot.getRenderer();
            Point2D p = this.translateScreenToJava2D(e.getPoint());
            annot.setX(Canvas.java2Dtochart(this, p.getX(), true) - this.saveDecalageX);
            annot.setY(Canvas.java2Dtochart(this, p.getY(), false) - this.saveDecalageY);
            XYIDAnnotation annot2 = new XYIDAnnotation(annot.getText(), annot.getLblx(), annot.getLbly(), annot.getPtsx(), annot.getPtsy(), annot.getColor());
            annot2.setFont(annot.getFont());
            annot2.setTextAnchor(annot.getTextAnchor());
            this.getCanvas().remplaceAnnot(annot2, this.getCanvas().indexOfAnnot(annot));
            renderer.removeAnnotation(this.getLine());
            if (this.getCanvas().tailleBranche() > 0) {
                int i = 0;
                while (i < this.getCanvas().tailleBranche()) {
                    renderer.addAnnotation(this.getCanvas().getBranche(i));
                    ++i;
                }
            }
            this.setLine(null);
            renderer.setAnnotationsRearrangees(true);
        }
        if (!(this.ClickRight || this.zoomRectangle == null && this.getLine() != null)) {
            boolean hZoom = false;
            boolean vZoom = false;
            if (this.orientation == PlotOrientation.HORIZONTAL) {
                hZoom = this.rangeZoomable;
                vZoom = this.domainZoomable;
            } else {
                hZoom = this.domainZoomable;
                vZoom = this.rangeZoomable;
            }
            boolean zoomTrigger1 = false;
            boolean zoomTrigger2 = false;
            if (!this.isMoove && this.zoomRectangle == null) {
                zoomTrigger1 = hZoom && Math.abs((double)e.getX() - this.selectPoint.getX()) >= (double)this.zoomTriggerDistance;
                zoomTrigger2 = vZoom && Math.abs((double)e.getY() - this.selectPoint.getY()) >= (double)this.zoomTriggerDistance;
            } else if (this.zoomRectangle != null) {
                zoomTrigger1 = hZoom && Math.abs((double)e.getX() - this.zoomPoint.getX()) >= (double)this.zoomTriggerDistance;
                boolean bl = zoomTrigger2 = vZoom && Math.abs((double)e.getY() - this.zoomPoint.getY()) >= (double)this.zoomTriggerDistance;
            }
            if (zoomTrigger1 || zoomTrigger2) {
                boolean isZoom = true;
                if (!this.isMoove && this.zoomRectangle == null) {
                    if (hZoom && (double)e.getX() < this.selectPoint.getX() || vZoom && (double)e.getY() < this.selectPoint.getY()) {
                        this.restoreAutoBounds();
                        isZoom = false;
                    }
                } else if (hZoom && (double)e.getX() < this.zoomPoint.getX() || vZoom && (double)e.getY() < this.zoomPoint.getY()) {
                    this.restoreAutoBounds();
                    isZoom = false;
                }
                if (isZoom) {
                    double h;
                    double w;
                    double y;
                    double x;
                    Rectangle2D screenDataArea;
                    if (!this.isMoove && this.zoomRectangle == null && this.selectRectangle != null) {
                        screenDataArea = this.getScreenDataArea((int)this.selectPoint.getX(), (int)this.selectPoint.getY());
                        if (!vZoom) {
                            x = this.zoomPoint.getX();
                            y = screenDataArea.getMinY();
                            w = Math.min(this.selectRectangle.getWidth(), screenDataArea.getMaxX() - this.selectPoint.getX());
                            h = screenDataArea.getHeight();
                        } else if (!hZoom) {
                            x = screenDataArea.getMinX();
                            y = this.selectPoint.getY();
                            w = screenDataArea.getWidth();
                            h = Math.min(this.selectRectangle.getHeight(), screenDataArea.getMaxY() - this.selectPoint.getY());
                        } else {
                            x = this.selectPoint.getX();
                            y = this.selectPoint.getY();
                            w = Math.min(this.selectRectangle.getWidth(), screenDataArea.getMaxX() - this.selectPoint.getX());
                            h = Math.min(this.selectRectangle.getHeight(), screenDataArea.getMaxY() - this.selectPoint.getY());
                        }
                    } else if (this.zoomPoint != null) {
                        screenDataArea = this.getScreenDataArea((int)this.zoomPoint.getX(), (int)this.zoomPoint.getY());
                        if (!vZoom) {
                            x = this.zoomPoint.getX();
                            y = screenDataArea.getMinY();
                            w = Math.min(this.zoomRectangle.getWidth(), screenDataArea.getMaxX() - this.zoomPoint.getX());
                            h = screenDataArea.getHeight();
                        } else if (!hZoom) {
                            x = screenDataArea.getMinX();
                            y = this.zoomPoint.getY();
                            w = screenDataArea.getWidth();
                            h = Math.min(this.zoomRectangle.getHeight(), screenDataArea.getMaxY() - this.zoomPoint.getY());
                        } else {
                            x = this.zoomPoint.getX();
                            y = this.zoomPoint.getY();
                            w = Math.min(this.zoomRectangle.getWidth(), screenDataArea.getMaxX() - this.zoomPoint.getX());
                            h = Math.min(this.zoomRectangle.getHeight(), screenDataArea.getMaxY() - this.zoomPoint.getY());
                        }
                    } else {
                        x = 0.0;
                        y = 0.0;
                        w = 0.0;
                        h = 0.0;
                    }
                    if (!this.isMoove && this.zoomRectangle == null) {
                        Point2D p = this.translateScreenToJava2D(new Point(Math.round(Math.round(x)), Math.round(Math.round(y))));
                        Point2D d = this.translateScreenToJava2D(new Point(Math.round(Math.round(w)), Math.round(Math.round(h))));
                        this.selectRectangle = new Rectangle2D.Double(p.getX(), p.getY(), d.getX(), d.getY());
                        this.sel = new SelectZone(this.getCanvas().findPoint(this, this.selectRectangle));
                        this.getGestionnaire().addSelectionnes(this.sel.getSelect());
                    } else {
                        Rectangle2D.Double zoomArea = new Rectangle2D.Double(x, y, w, h);
                        this.zoom(zoomArea);
                    }
                }
                this.selectPoint = null;
                this.zoomPoint = null;
                this.selectRectangle = null;
                this.zoomRectangle = null;
            } else {
                Graphics2D g2 = (Graphics2D)this.getGraphics();
                if (this.getLine() == null) {
                    this.drawSelectRectangle(g2);
                } else {
                    this.drawZoomRectangle(g2);
                }
                g2.dispose();
                this.selectPoint = null;
                this.zoomPoint = null;
                this.selectRectangle = null;
                this.zoomRectangle = null;
            }
        }
        if (e.isPopupTrigger() && this.popup != null) {
            this.displayPopupMenu(e.getX(), e.getY());
        }
        this.repaint();
    }

    public void mouseClicked(MouseEvent event) {
        EntityCollection entities;
        Insets insets = this.getInsets();
        int x = (int)((double)(event.getX() - insets.left) / this.scaleX);
        int y = (int)((double)(event.getY() - insets.top) / this.scaleY);
        this.anchor = new Point2D.Double(x, y);
        if (this.chart == null) {
            return;
        }
        this.chart.setNotify(true);
        Object[] listeners = this.chartMouseListeners.getListeners(ChartMouseListener.class);
        if (listeners.length == 0) {
            return;
        }
        ChartEntity entity = null;
        if (this.info != null && (entities = this.info.getEntityCollection()) != null) {
            entity = entities.getEntity(x, y);
        }
        ChartMouseEvent chartEvent = new ChartMouseEvent(this.getChart(), event, entity);
        int i = listeners.length - 1;
        while (i >= 0) {
            ((ChartMouseListener)listeners[i]).chartMouseClicked(chartEvent);
            --i;
        }
    }

    public void mouseMoved(MouseEvent e) {
        EntityCollection entities;
        Graphics2D g2 = (Graphics2D)this.getGraphics();
        if (this.horizontalAxisTrace) {
            this.drawHorizontalAxisTrace(g2, e.getX());
        }
        if (this.verticalAxisTrace) {
            this.drawVerticalAxisTrace(g2, e.getY());
        }
        g2.dispose();
        Object[] listeners = this.chartMouseListeners.getListeners(ChartMouseListener.class);
        if (listeners.length == 0) {
            return;
        }
        Insets insets = this.getInsets();
        int x = (int)((double)(e.getX() - insets.left) / this.scaleX);
        int y = (int)((double)(e.getY() - insets.top) / this.scaleY);
        ChartEntity entity = null;
        if (this.info != null && (entities = this.info.getEntityCollection()) != null) {
            entity = entities.getEntity(x, y);
        }
        if (this.chart != null) {
            ChartMouseEvent event = new ChartMouseEvent(this.getChart(), e, entity);
            int i = listeners.length - 1;
            while (i >= 0) {
                ((ChartMouseListener)listeners[i]).chartMouseMoved(event);
                --i;
            }
        }
    }

    public void zoomInBoth(double x, double y) {
        this.zoomInDomain(x, y);
        this.zoomInRange(x, y);
    }

    public void zoomInDomain(double x, double y) {
        Plot p = this.chart.getPlot();
        if (p instanceof Zoomable) {
            Zoomable plot = (Zoomable)((Object)p);
            plot.zoomDomainAxes(this.zoomInFactor, this.info.getPlotInfo(), this.translateScreenToJava2D(new Point((int)x, (int)y)));
        }
    }

    public void zoomInRange(double x, double y) {
        Plot p = this.chart.getPlot();
        if (p instanceof Zoomable) {
            Zoomable z = (Zoomable)((Object)p);
            z.zoomRangeAxes(this.zoomInFactor, this.info.getPlotInfo(), this.translateScreenToJava2D(new Point((int)x, (int)y)));
        }
    }

    public void zoomOutBoth(double x, double y) {
        this.zoomOutDomain(x, y);
        this.zoomOutRange(x, y);
    }

    public void zoomOutDomain(double x, double y) {
        Plot p = this.chart.getPlot();
        if (p instanceof Zoomable) {
            Zoomable z = (Zoomable)((Object)p);
            z.zoomDomainAxes(this.zoomOutFactor, this.info.getPlotInfo(), this.translateScreenToJava2D(new Point((int)x, (int)y)));
        }
    }

    public void zoomOutRange(double x, double y) {
        Plot p = this.chart.getPlot();
        if (p instanceof Zoomable) {
            Zoomable z = (Zoomable)((Object)p);
            z.zoomRangeAxes(this.zoomOutFactor, this.info.getPlotInfo(), this.translateScreenToJava2D(new Point((int)x, (int)y)));
        }
    }

    public void zoom(Rectangle2D selection) {
        Point2D selectOrigin = this.translateScreenToJava2D(new Point((int)Math.ceil(selection.getX()), (int)Math.ceil(selection.getY())));
        PlotRenderingInfo plotInfo = this.info.getPlotInfo();
        Rectangle2D scaledDataArea = this.getScreenDataArea((int)selection.getCenterX(), (int)selection.getCenterY());
        if (selection.getHeight() > 0.0 && selection.getWidth() > 0.0) {
            double hLower = (selection.getMinX() - scaledDataArea.getMinX()) / scaledDataArea.getWidth();
            double hUpper = (selection.getMaxX() - scaledDataArea.getMinX()) / scaledDataArea.getWidth();
            double vLower = (scaledDataArea.getMaxY() - selection.getMaxY()) / scaledDataArea.getHeight();
            double vUpper = (scaledDataArea.getMaxY() - selection.getMinY()) / scaledDataArea.getHeight();
            Plot p = this.chart.getPlot();
            if (p instanceof Zoomable) {
                Zoomable z = (Zoomable)((Object)p);
                if (z.getOrientation() == PlotOrientation.HORIZONTAL) {
                    z.zoomDomainAxes(vLower, vUpper, plotInfo, selectOrigin);
                    z.zoomRangeAxes(hLower, hUpper, plotInfo, selectOrigin);
                } else {
                    z.zoomDomainAxes(hLower, hUpper, plotInfo, selectOrigin);
                    z.zoomRangeAxes(vLower, vUpper, plotInfo, selectOrigin);
                }
            }
        }
    }

    public void restoreAutoBounds() {
        this.restoreAutoDomainBounds();
        this.restoreAutoRangeBounds();
    }

    public void restoreAutoDomainBounds() {
        Plot p = this.chart.getPlot();
        if (p instanceof Zoomable) {
            Zoomable z = (Zoomable)((Object)p);
            z.zoomDomainAxes(0.0, this.info.getPlotInfo(), this.zoomPoint);
        }
    }

    public void restoreAutoRangeBounds() {
        Plot p = this.chart.getPlot();
        if (p instanceof Zoomable) {
            Zoomable z = (Zoomable)((Object)p);
            z.zoomRangeAxes(0.0, this.info.getPlotInfo(), this.zoomPoint);
        }
    }

    public Rectangle2D getScreenDataArea() {
        Rectangle2D dataArea = this.info.getPlotInfo().getDataArea();
        Insets insets = this.getInsets();
        double x = dataArea.getX() * this.scaleX + (double)insets.left;
        double y = dataArea.getY() * this.scaleY + (double)insets.top;
        double w = dataArea.getWidth() * this.scaleX;
        double h = dataArea.getHeight() * this.scaleY;
        return new Rectangle2D.Double(x, y, w, h);
    }

    public Rectangle2D getScreenDataArea(int x, int y) {
        Rectangle2D result;
        PlotRenderingInfo plotInfo = this.info.getPlotInfo();
        if (plotInfo.getSubplotCount() == 0) {
            result = this.getScreenDataArea();
        } else {
            Point2D selectOrigin = this.translateScreenToJava2D(new Point(x, y));
            int subplotIndex = plotInfo.getSubplotIndex(selectOrigin);
            if (subplotIndex == -1) {
                return null;
            }
            result = this.scale(plotInfo.getSubplotInfo(subplotIndex).getDataArea());
        }
        return result;
    }

    public int getInitialDelay() {
        return this.ownToolTipInitialDelay;
    }

    public int getReshowDelay() {
        return this.ownToolTipReshowDelay;
    }

    public int getDismissDelay() {
        return this.ownToolTipDismissDelay;
    }

    public void setInitialDelay(int delay) {
        this.ownToolTipInitialDelay = delay;
    }

    public void setReshowDelay(int delay) {
        this.ownToolTipReshowDelay = delay;
    }

    public void setDismissDelay(int delay) {
        this.ownToolTipDismissDelay = delay;
    }

    public double getZoomInFactor() {
        return this.zoomInFactor;
    }

    public void setZoomInFactor(double factor) {
        this.zoomInFactor = factor;
    }

    public double getZoomOutFactor() {
        return this.zoomOutFactor;
    }

    public void setZoomOutFactor(double factor) {
        this.zoomOutFactor = factor;
    }

    private void drawZoomRectangle(Graphics2D g2) {
        g2.setXORMode(Color.gray);
        if (this.zoomRectangle != null) {
            if (this.fillZoomRectangle) {
                g2.fill(this.zoomRectangle);
            } else {
                g2.draw(this.zoomRectangle);
            }
        }
        g2.setPaintMode();
    }

    private void drawSelectRectangle(Graphics2D g2) {
        g2.setXORMode(Color.gray);
        if (this.selectRectangle != null) {
            g2.draw(this.selectRectangle);
        }
        g2.setPaintMode();
    }

    private void drawHorizontalAxisTrace(Graphics2D g2, int x) {
        Rectangle2D dataArea = this.getScreenDataArea();
        g2.setXORMode(Color.orange);
        if ((int)dataArea.getMinX() < x && x < (int)dataArea.getMaxX()) {
            if (this.verticalTraceLine != null) {
                g2.draw(this.verticalTraceLine);
                this.verticalTraceLine.setLine(x, (int)dataArea.getMinY(), x, (int)dataArea.getMaxY());
            } else {
                this.verticalTraceLine = new Line2D.Float(x, (int)dataArea.getMinY(), x, (int)dataArea.getMaxY());
            }
            g2.draw(this.verticalTraceLine);
        }
        g2.setPaintMode();
    }

    private void drawVerticalAxisTrace(Graphics2D g2, int y) {
        Rectangle2D dataArea = this.getScreenDataArea();
        g2.setXORMode(Color.orange);
        if ((int)dataArea.getMinY() < y && y < (int)dataArea.getMaxY()) {
            if (this.horizontalTraceLine != null) {
                g2.draw(this.horizontalTraceLine);
                this.horizontalTraceLine.setLine((int)dataArea.getMinX(), y, (int)dataArea.getMaxX(), y);
            } else {
                this.horizontalTraceLine = new Line2D.Float((int)dataArea.getMinX(), y, (int)dataArea.getMaxX(), y);
            }
            g2.draw(this.horizontalTraceLine);
        }
        g2.setPaintMode();
    }

    public void doEditChartProperties() {
        ChartEditor editor = ChartEditorManager.getChartEditor(this.chart);
        int result = JOptionPane.showConfirmDialog(this, editor, IHM.getXmlLangue().getElement("Chart_Properties"), 2, -1);
        if (result == 0) {
            editor.updateChart(this.chart);
        }
    }

    public void doSaveAs() throws IOException {
        this.doSaveAs(IHM.getXmlLangue().getElement("Save_as..."), IHM.getXmlLangue().getElement("Mexporter..."));
    }

    public void doSaveAs(String titre, String bouton) throws IOException {
        JFileChooser fileChooser = new JFileChooser();
        ExtensionFileFilter filterSVG = new ExtensionFileFilter(IHM.getXmlLangue().getElement("SVG_Image_Files"), ".svg");
        ExtensionFileFilter filterPDF = new ExtensionFileFilter(IHM.getXmlLangue().getElement("PDF_Image_Files"), ".pdf");
        ExtensionFileFilter filterEMF = new ExtensionFileFilter(IHM.getXmlLangue().getElement("EMF_Image_Files"), ".emf");
        ExtensionFileFilter filterPNG = new ExtensionFileFilter(IHM.getXmlLangue().getElement("PNG_Image_Files"), ".png");
        fileChooser.addChoosableFileFilter(filterSVG);
        fileChooser.addChoosableFileFilter(filterPDF);
        fileChooser.addChoosableFileFilter(filterEMF);
        fileChooser.addChoosableFileFilter(filterPNG);
        fileChooser.setDialogTitle(titre);
        int option = fileChooser.showDialog(this, bouton);
        if (option == 0) {
            String filename = fileChooser.getSelectedFile().getPath();
            ExtensionFileFilter ff = (ExtensionFileFilter)fileChooser.getFileFilter();
            String ext = ff.getExtension();
            if (this.isEnforceFileExtensions() && !filename.endsWith(ext)) {
                filename = String.valueOf(filename) + ext;
            }
            int width = this.getWidth();
            int height = this.getHeight();
            if (fileChooser.getFileFilter().equals(filterPNG)) {
                ChartUtilities.saveChartAsPNG(new File(filename), this.chart, width, height);
            } else {
                SVGGraphics2D graphics;
                File f = new File(filename);
                if (fileChooser.getFileFilter().equals(filterSVG)) {
                    graphics = new SVGGraphics2D(f, new Dimension(width, height));
                } else if (fileChooser.getFileFilter().equals(filterPDF)) {
                    graphics = new PDFGraphics2D(f, new Dimension(width, height));
                    PDFGraphics2D.setClipEnabled((boolean)false);
                } else if (fileChooser.getFileFilter().equals(filterEMF)) {
                    graphics = new EMFGraphics2D(f, new Dimension(width, height));
                } else {
                    throw new IOException(IHM.getXmlLangue().getElement("erreur"));
                }
                this.chart.exporterVect((VectorGraphics)graphics, width, height, this.info);
            }
        }
    }

    public void createChartPrintJob() {
        PageFormat pf;
        PrinterJob job = PrinterJob.getPrinterJob();
        PageFormat pf2 = job.pageDialog(pf = job.defaultPage());
        if (pf2 != pf) {
            job.setPrintable(this, pf2);
            if (job.printDialog()) {
                try {
                    job.print();
                }
                catch (PrinterException e) {
                    JOptionPane.showMessageDialog(this, e);
                }
            }
        }
    }

    public int print(Graphics g, PageFormat pf, int pageIndex) {
        if (pageIndex != 0) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        double x = pf.getImageableX();
        double y = pf.getImageableY();
        double w = pf.getImageableWidth();
        double h = pf.getImageableHeight();
        this.chart.draw(g2, new Rectangle2D.Double(x, y, w, h), this.anchor, null);
        return 0;
    }

    public void addChartMouseListener(ChartMouseListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null 'listener' argument.");
        }
        this.chartMouseListeners.add(ChartMouseListener.class, listener);
    }

    public void removeChartMouseListener(ChartMouseListener listener) {
        this.chartMouseListeners.remove(ChartMouseListener.class, listener);
    }

    public EventListener[] getListeners(Class listenerType) {
        if (listenerType == ChartMouseListener.class) {
            return this.chartMouseListeners.getListeners(listenerType);
        }
        return super.getListeners(listenerType);
    }

    protected JPopupMenu createPopupMenu(boolean properties, boolean save, boolean print, boolean zoom) {
        JPopupMenu result = new JPopupMenu("Chart:");
        if (properties) {
            JMenuItem propertiesItem = new JMenuItem(IHM.getXmlLangue().getElement("Properties..."));
            propertiesItem.setActionCommand(PROPERTIES_COMMAND);
            propertiesItem.addActionListener(this);
            result.add(propertiesItem);
            JMenuItem habillageItem = new JMenuItem(String.valueOf(IHM.getXmlLangue().getElement("Mhabillage")) + "...");
            habillageItem.setActionCommand(HABILLAGE_COMMAND);
            habillageItem.addActionListener(this);
            result.add(habillageItem);
        }
        if (save) {
            JMenuItem saveItem = new JMenuItem(IHM.getXmlLangue().getElement("Mexporter..."));
            saveItem.setActionCommand(SAVE_COMMAND);
            saveItem.addActionListener(this);
            result.add(saveItem);
        }
        if (print) {
            JMenuItem printItem = new JMenuItem(IHM.getXmlLangue().getElement("Print..."));
            printItem.setActionCommand(PRINT_COMMAND);
            printItem.addActionListener(this);
            result.add(printItem);
        }
        if (zoom) {
            this.zoomResetBothMenuItem = new JMenuItem(IHM.getXmlLangue().getElement("Auto_Range"));
            this.zoomResetBothMenuItem.setActionCommand(ZOOM_RESET_BOTH_COMMAND);
            this.zoomResetBothMenuItem.addActionListener(this);
            result.add(this.zoomResetBothMenuItem);
        }
        return result;
    }

    protected void updatePopupMenu() {
        this.popup = this.createPopupMenu(true, true, true, true);
    }

    protected void displayPopupMenu(int x, int y) {
        if (this.popup != null) {
            Plot plot = this.chart.getPlot();
            boolean isDomainZoomable = false;
            boolean isRangeZoomable = false;
            if (plot instanceof Zoomable) {
                Zoomable z = (Zoomable)((Object)plot);
                isDomainZoomable = z.isDomainZoomable();
                isRangeZoomable = z.isRangeZoomable();
            }
            if (this.zoomInDomainMenuItem != null) {
                this.zoomInDomainMenuItem.setEnabled(isDomainZoomable);
            }
            if (this.zoomOutDomainMenuItem != null) {
                this.zoomOutDomainMenuItem.setEnabled(isDomainZoomable);
            }
            if (this.zoomResetDomainMenuItem != null) {
                this.zoomResetDomainMenuItem.setEnabled(isDomainZoomable);
            }
            if (this.zoomInRangeMenuItem != null) {
                this.zoomInRangeMenuItem.setEnabled(isRangeZoomable);
            }
            if (this.zoomOutRangeMenuItem != null) {
                this.zoomOutRangeMenuItem.setEnabled(isRangeZoomable);
            }
            if (this.zoomResetRangeMenuItem != null) {
                this.zoomResetRangeMenuItem.setEnabled(isRangeZoomable);
            }
            if (this.zoomInBothMenuItem != null) {
                this.zoomInBothMenuItem.setEnabled(isDomainZoomable && isRangeZoomable);
            }
            if (this.zoomOutBothMenuItem != null) {
                this.zoomOutBothMenuItem.setEnabled(isDomainZoomable && isRangeZoomable);
            }
            if (this.zoomResetBothMenuItem != null) {
                this.zoomResetBothMenuItem.setEnabled(isDomainZoomable && isRangeZoomable);
            }
            this.popup.show(this, x, y);
        }
    }

    public void updateLang() {
        this.updatePopupMenu();
    }
}

