/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.desktop;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.WeakHashMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import org.jvnet.lafwidget.LafWidgetAdapter;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.LafWidgetSupport;
import org.jvnet.lafwidget.LafWidgetUtilities;

public class DesktopIconHoverPreviewWidget
extends LafWidgetAdapter {
    protected JInternalFrame.JDesktopIcon desktopIcon;
    protected JComponent compToHover;
    protected PropertyChangeListener internalFramePropertyListener;
    private static WeakHashMap snapshots = new WeakHashMap();
    private JWindow previewWindow;
    private boolean isInDrag;
    protected TitleMouseHandler titleMouseHandler;

    public void setComponent(JComponent jcomp) {
        super.setComponent(jcomp);
        this.desktopIcon = (JInternalFrame.JDesktopIcon)jcomp;
    }

    public void installComponents() {
        this.previewWindow = new JWindow();
        this.previewWindow.getContentPane().setLayout(new BorderLayout());
    }

    public void installListeners() {
        this.internalFramePropertyListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("ancestor".equals(evt.getPropertyName())) {
                    DesktopIconHoverPreviewWidget.updateSnapshot(DesktopIconHoverPreviewWidget.this.desktopIcon.getInternalFrame());
                }
            }
        };
        this.desktopIcon.getInternalFrame().addPropertyChangeListener(this.internalFramePropertyListener);
        this.titleMouseHandler = new TitleMouseHandler();
        LafWidgetSupport lafSupport = LafWidgetRepository.getRepository().getLafSupport();
        this.compToHover = lafSupport.getComponentForHover(this.desktopIcon);
        if (this.compToHover != null) {
            this.compToHover.addMouseMotionListener(this.titleMouseHandler);
            this.compToHover.addMouseListener(this.titleMouseHandler);
        }
    }

    public void uninstallListeners() {
        this.desktopIcon.getInternalFrame().removePropertyChangeListener(this.internalFramePropertyListener);
        this.internalFramePropertyListener = null;
        if (this.compToHover != null) {
            this.compToHover.removeMouseMotionListener(this.titleMouseHandler);
            this.compToHover.removeMouseListener(this.titleMouseHandler);
        }
        this.titleMouseHandler = null;
    }

    private void syncPreviewWindow(boolean toShow) {
        if (toShow) {
            int x = this.desktopIcon.getLocationOnScreen().x;
            int y = this.desktopIcon.getLocationOnScreen().y;
            this.previewWindow.setLocation(x, y - this.previewWindow.getHeight());
        }
    }

    private static void updateSnapshot(JInternalFrame frame) {
        if (!frame.isShowing()) {
            return;
        }
        int frameWidth = frame.getWidth();
        int frameHeight = frame.getHeight();
        int dx = 0;
        int dy = 0;
        Border internalFrameBorder = UIManager.getBorder("InternalFrame.border");
        Insets borderInsets = internalFrameBorder.getBorderInsets(frame);
        dx += borderInsets.left;
        dy += borderInsets.top;
        frameWidth -= borderInsets.left + borderInsets.right;
        frameHeight -= borderInsets.top + borderInsets.bottom;
        BasicInternalFrameUI frameUI = (BasicInternalFrameUI)frame.getUI();
        JComponent frameTitlePane = frameUI.getNorthPane();
        if (frameTitlePane != null) {
            dy += frameTitlePane.getHeight();
            frameHeight -= frameTitlePane.getHeight();
        }
        if (frameWidth > 0 && frameHeight > 0) {
            int maxWidth;
            BufferedImage tempCanvas = new BufferedImage(frameWidth, frameHeight, 2);
            Graphics tempCanvasGraphics = tempCanvas.getGraphics();
            tempCanvasGraphics.translate(-dx, -dy);
            frame.paint(tempCanvasGraphics);
            int maxHeight = maxWidth = UIManager.getInt("DesktopIcon.width");
            double coef = Math.min((double)maxWidth / (double)frameWidth, (double)maxHeight / (double)frameHeight);
            if (coef < 1.0) {
                int sdWidth = (int)(coef * (double)frameWidth);
                BufferedImage scaledDown = LafWidgetUtilities.createThumbnail(tempCanvas, sdWidth);
                snapshots.put(frame, scaledDown);
            } else {
                snapshots.put(frame, tempCanvas);
            }
        }
    }

    public static synchronized BufferedImage getSnapshot(JInternalFrame frame) {
        BufferedImage result = (BufferedImage)snapshots.get(frame);
        if (result != null) {
            return result;
        }
        return null;
    }

    public boolean requiresCustomLafSupport() {
        return false;
    }

    protected class TitleMouseHandler
    extends MouseInputAdapter {
        protected TitleMouseHandler() {
        }

        public void mouseEntered(MouseEvent e) {
            if (DesktopIconHoverPreviewWidget.this.isInDrag) {
                return;
            }
            BufferedImage previewImage = DesktopIconHoverPreviewWidget.getSnapshot(DesktopIconHoverPreviewWidget.this.desktopIcon.getInternalFrame());
            if (previewImage != null) {
                DesktopIconHoverPreviewWidget.this.previewWindow.getContentPane().removeAll();
                JLabel previewLabel = new JLabel(new ImageIcon(previewImage));
                DesktopIconHoverPreviewWidget.this.previewWindow.getContentPane().add((Component)previewLabel, "Center");
                DesktopIconHoverPreviewWidget.this.previewWindow.setSize(previewImage.getWidth(), previewImage.getHeight());
                DesktopIconHoverPreviewWidget.this.syncPreviewWindow(true);
                DesktopIconHoverPreviewWidget.this.previewWindow.setVisible(true);
            }
        }

        public void mouseExited(MouseEvent e) {
            DesktopIconHoverPreviewWidget.this.isInDrag = false;
            DesktopIconHoverPreviewWidget.this.previewWindow.dispose();
        }

        public void mousePressed(MouseEvent e) {
            DesktopIconHoverPreviewWidget.this.previewWindow.dispose();
        }

        public void mouseReleased(MouseEvent e) {
            DesktopIconHoverPreviewWidget.this.isInDrag = false;
            DesktopIconHoverPreviewWidget.this.syncPreviewWindow(true);
            DesktopIconHoverPreviewWidget.this.previewWindow.setVisible(true);
        }

        public void mouseDragged(MouseEvent e) {
            DesktopIconHoverPreviewWidget.this.isInDrag = true;
            if (DesktopIconHoverPreviewWidget.this.previewWindow.isVisible()) {
                DesktopIconHoverPreviewWidget.this.syncPreviewWindow(false);
                DesktopIconHoverPreviewWidget.this.previewWindow.dispose();
            }
        }
    }
}

