/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.util;

import java.io.File;
import java.io.IOException;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.util.SimpleFrame;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class SimpleBarChart {
    public JFreeChart chart;
    private SimpleFrame frame = null;

    public SimpleBarChart(CategoryDataset dataset) {
        this.init(dataset);
    }

    public SimpleBarChart(double[] values, String[] categoryNames, String seriesName) {
        if (values == null || categoryNames == null) {
            throw new IllegalArgumentException("Valid values and category names must be provided");
        }
        if (values.length != categoryNames.length) {
            throw new IllegalArgumentException("The number of values must equal the number of category names");
        }
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        int iNbrValues = values.length;
        int i = 0;
        while (i < iNbrValues) {
            double dValue = values[i];
            String strCategoryName = categoryNames[i];
            dataset.addValue(dValue, (Comparable)((Object)seriesName), (Comparable)((Object)strCategoryName));
            ++i;
        }
        this.init(dataset);
    }

    public SimpleBarChart(double[][] values, String[][] categoryNames, String[] seriesNames) {
        if (values == null || categoryNames == null || seriesNames == null) {
            throw new IllegalArgumentException("Valid values, category, and series names must be provided");
        }
        if (seriesNames.length != values.length) {
            throw new IllegalArgumentException("The number of values must equal the number of series names");
        }
        if (seriesNames.length != categoryNames.length) {
            throw new IllegalArgumentException("The number of values must equal the number of series names");
        }
        int iNbrSeries = seriesNames.length;
        int i = 0;
        while (i < iNbrSeries) {
            int iNbrSeriesValues = values[i].length;
            int iNbrCategoryValues = categoryNames[i].length;
            if (iNbrSeriesValues != iNbrCategoryValues) {
                throw new IllegalArgumentException("In series " + i + " the number of values must equal the number of series names");
            }
            ++i;
        }
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        int i2 = 0;
        while (i2 < iNbrSeries) {
            double[] dAryValues = values[i2];
            String[] strAryCategoryNames = categoryNames[i2];
            String strSeriesName = seriesNames[i2];
            int iNbrValues = dAryValues.length;
            int j = 0;
            while (j < iNbrValues) {
                double dValue = dAryValues[j];
                String strCategoryName = strAryCategoryNames[j];
                dataset.addValue(dValue, (Comparable)((Object)strSeriesName), (Comparable)((Object)strCategoryName));
                ++j;
            }
            ++i2;
        }
        this.init(dataset);
    }

    private void init(CategoryDataset dataset) {
        String strTitle = "";
        this.chart = ChartFactory.createBarChart(strTitle, "Category", "Value", dataset, PlotOrientation.VERTICAL, true, true, false);
    }

    public void setTitle(String title) {
        this.chart.setTitle(title);
        if (this.frame != null) {
            this.frame.setTitle(title);
        }
    }

    public void display() {
        if (this.frame == null) {
            this.frame = new SimpleFrame(this.chart);
        }
        this.frame.setSize(600, 350);
        this.frame.setVisible(true);
        this.frame.setTitle(this.chart.getTitle().getText());
    }

    public void saveAs(String fileName) throws IOException {
        File file = new File(fileName);
        ChartUtilities.saveChartAsPNG(file, this.chart, 600, 400);
    }

    public void setCategoryLabel(String label) {
        ((CategoryPlot)this.chart.getPlot()).setDomainAxis(new CategoryAxis(label));
    }

    public void setValuesLabel(String label) {
        ((CategoryPlot)this.chart.getPlot()).setRangeAxis(new NumberAxis(label));
    }

    public void setWindowSize(int width, int height) {
        if (this.frame == null) {
            return;
        }
        this.frame.setSize(width, height);
    }
}

