/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.Fittable1DFunction;
import jas.hist.Fitter;
import jas.hist.FunctionValueUndefined;
import jas.hist.InvalidFunctionParameter;

class FitAdapter1D
extends Fittable1DFunction {
    private double[] fitterParameters;
    private double[] functionParameters;
    private boolean[] inFit;
    private Fittable1DFunction func;

    public FitAdapter1D(Fittable1DFunction func) {
        int i;
        this.func = func;
        this.inFit = func.getIncludeParametersInFit();
        this.functionParameters = func.getParameterValues();
        double[] temp = new double[this.functionParameters.length];
        int j = 0;
        for (i = 0; i < this.inFit.length; ++i) {
            if (!this.inFit[i]) continue;
            temp[j++] = this.functionParameters[i];
        }
        if (j == this.functionParameters.length) {
            this.fitterParameters = temp;
        } else {
            this.fitterParameters = new double[j];
            for (i = 0; i < j; ++i) {
                this.fitterParameters[i] = temp[i];
            }
        }
    }

    public double[] getParameterValues() {
        return this.fitterParameters;
    }

    public boolean[] getIncludedInFit() {
        return this.inFit;
    }

    public double[] getDerivatives(double x, double[] a) throws FunctionValueUndefined {
        this.updateParameters(a);
        double[] fullAnswer = this.func.getDerivatives(x, this.functionParameters);
        if (this.functionParameters.length == this.fitterParameters.length) {
            return fullAnswer;
        }
        double[] condensedAnswer = new double[this.fitterParameters.length];
        int i = 0;
        for (int j = 0; j < fullAnswer.length; ++j) {
            if (!this.inFit[j]) continue;
            condensedAnswer[i++] = fullAnswer[j];
        }
        return condensedAnswer;
    }

    public double valueAt(double x, double[] a) throws FunctionValueUndefined {
        this.updateParameters(a);
        return this.func.valueAt(x, this.functionParameters);
    }

    public void setFit(Fitter f, double[] a) throws InvalidFunctionParameter {
        this.updateParameters(a);
        this.func.setFit(f, this.functionParameters);
    }

    private void updateParameters(double[] fitterParameters) {
        this.fitterParameters = fitterParameters;
        if (this.functionParameters.length == fitterParameters.length) {
            this.functionParameters = fitterParameters;
        } else {
            int i = 0;
            for (int j = 0; j < this.functionParameters.length; ++j) {
                if (!this.inFit[j]) continue;
                this.functionParameters[j] = fitterParameters[i++];
            }
        }
    }

    public boolean[] getIncludeParametersInFit() {
        return this.inFit;
    }

    public String[] getParameterNames() {
        return this.func.getParameterNames();
    }

    public String getTitle() {
        return this.func.getTitle();
    }

    public void setParameter(int i, double d) throws InvalidFunctionParameter {
        if (this.fitterParameters.length == this.functionParameters.length) {
            this.func.setParameter(i, d);
        } else {
            for (int j = 0; j <= i; ++j) {
                if (this.inFit[j]) continue;
                ++i;
            }
        }
        this.func.setParameter(i, d);
    }

    public double valueAt(double d) throws FunctionValueUndefined {
        return this.func.valueAt(d);
    }
}

