/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.text;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.LafWidgetSupport;
import org.jvnet.lafwidget.LafWidgetUtilities;

public class LockBorder
implements Border,
UIResource {
    private Border originalBorder;

    public LockBorder(Border originalBorder) {
        this.originalBorder = originalBorder != null ? originalBorder : new EmptyBorder(0, 0, 0, 0);
    }

    public Insets getBorderInsets(Component c) {
        LafWidgetSupport lafSupport = LafWidgetRepository.getRepository().getLafSupport();
        Icon lockIcon = lafSupport.getLockIcon();
        if (lockIcon == null) {
            lockIcon = LafWidgetUtilities.getSmallLockIcon();
        }
        Insets origInsets = this.originalBorder.getBorderInsets(c);
        if (c.getComponentOrientation().isLeftToRight()) {
            return new Insets(origInsets.top, Math.max(origInsets.left, lockIcon.getIconWidth() + 2), origInsets.bottom, origInsets.right);
        }
        return new Insets(origInsets.top, origInsets.left, origInsets.bottom, Math.max(origInsets.right, lockIcon.getIconWidth() + 2));
    }

    public boolean isBorderOpaque() {
        return this.originalBorder.isBorderOpaque();
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        this.originalBorder.paintBorder(c, g, x, y, width, height);
        LafWidgetSupport lafSupport = LafWidgetRepository.getRepository().getLafSupport();
        Icon lockIcon = lafSupport.getLockIcon();
        if (lockIcon == null) {
            lockIcon = LafWidgetUtilities.getSmallLockIcon();
        }
        if (c.getComponentOrientation().isLeftToRight()) {
            lockIcon.paintIcon(c, g, x, y + height - lockIcon.getIconHeight());
        } else {
            lockIcon.paintIcon(c, g, x + width - lockIcon.getIconWidth(), y + height - lockIcon.getIconHeight());
        }
    }
}

