/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.lafwidget.scroll;

import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.plaf.basic.ComboPopup;
import org.jvnet.lafwidget.LafWidgetAdapter;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.preview.PreviewPainter;
import org.jvnet.lafwidget.scroll.ScrollPaneSelector;

public class ScrollPaneSelectorWidget
extends LafWidgetAdapter {
    protected JScrollPane scrollPane;
    protected HierarchyListener hierarchyListener;
    protected PropertyChangeListener propertyChangeListener;

    public void setComponent(JComponent jcomp) {
        super.setComponent(jcomp);
        this.scrollPane = (JScrollPane)jcomp;
    }

    public boolean requiresCustomLafSupport() {
        return false;
    }

    public void installUI() {
        if (LafWidgetRepository.getRepository().getLafSupport().toInstallExtraElements(this.scrollPane)) {
            ScrollPaneSelector.installScrollPaneSelector(this.scrollPane);
        }
    }

    public void uninstallUI() {
        ScrollPaneSelector.uninstallScrollPaneSelector(this.scrollPane);
    }

    public void installListeners() {
        this.hierarchyListener = new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e) {
                if (ScrollPaneSelectorWidget.this.scrollPane.getParent() instanceof ComboPopup) {
                    ScrollPaneSelector.uninstallScrollPaneSelector(ScrollPaneSelectorWidget.this.scrollPane);
                }
            }
        };
        this.scrollPane.addHierarchyListener(this.hierarchyListener);
        this.propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("lafwidgets.componentPreviewPainter".equals(evt.getPropertyName())) {
                    PreviewPainter pPainter = LafWidgetUtilities.getComponentPreviewPainter(ScrollPaneSelectorWidget.this.scrollPane);
                    ScrollPaneSelector.uninstallScrollPaneSelector(ScrollPaneSelectorWidget.this.scrollPane);
                    if (pPainter != null) {
                        ScrollPaneSelector.installScrollPaneSelector(ScrollPaneSelectorWidget.this.scrollPane);
                    }
                }
            }
        };
        this.scrollPane.addPropertyChangeListener(this.propertyChangeListener);
    }

    public void uninstallListeners() {
        this.scrollPane.removeHierarchyListener(this.hierarchyListener);
        this.hierarchyListener = null;
        this.scrollPane.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }
}

