% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDyReliability.R
\name{getDyReliability}
\alias{getDyReliability}
\title{A Function Calculates Omega Total Coefficients from a Dyadic CFA}
\usage{
getDyReliability(dvn, fit)
}
\arguments{
\item{dvn}{input dvn list from scrapeVarCross}

\item{fit}{outputted dyadic cfa lavaan object based on the default (i.e., "configural") dyadCFA() function}
}
\value{
a tibble/data frame with calculated omega total coefficients for dyad Member 1 and Member 2
}
\description{
This function takes the  model from fitted scriptCFA() scripts and returns omega total coefficients
for each dyad member, adapted following Formula 2 in McNeish (2018).
}
\examples{
dvn <- scrapeVarCross(dat = commitmentQ, x_order = "spi", x_stem = "sat.g", x_delim1 = ".",
x_delim2="_", distinguish_1="1", distinguish_2="2")
sat.indist.script <-  scriptCFA(dvn, lvname = "Sat")
sat.indist.mod <- lavaan::cfa(sat.indist.script, data = commitmentQ, std.lv = FALSE,
auto.fix.first= FALSE, meanstructure = TRUE)
getDyReliability(dvn, sat.indist.mod)
}
\seealso{
Other supplemental model calculators: 
\code{\link{getDydmacs}()},
\code{\link{getIndistFit}()}
}
\concept{supplemental model calculators}
