% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle_gamma_lnorm.R
\name{mle_gamma_lnorm}
\alias{mle_gamma_lnorm}
\title{Maximum Likelihood Estimation for X[1], ..., X[n] ~ Gamma(alpha, beta) Lognormal(mu, sigsq)}
\usage{
mle_gamma_lnorm(x, gamma_mean1 = FALSE, lnorm_mean1 = TRUE,
  integrate_tol = 1e-08, estimate_var = FALSE, ...)
}
\arguments{
\item{x}{Numeric vector.}

\item{gamma_mean1}{Whether to use restriction that the Gamma variable is 
mean-1.}

\item{lnorm_mean1}{Whether to use restriction that the lognormal variable is 
mean-1.}

\item{integrate_tol}{Numeric value specifying the \code{tol} input to
\code{\link[cubature]{hcubature}}.}

\item{estimate_var}{Logical value for whether to return Hessian-based
variance-covariance matrix.}

\item{...}{Additional arguments to pass to \code{\link[stats]{nlminb}}.}
}
\value{
List containing:
\enumerate{
\item Numeric vector of parameter estimates.
\item Variance-covariance matrix (if \code{estimate_var = TRUE}).
\item Returned \code{\link[stats]{nlminb}} object from maximizing the
log-likelihood function.
\item Akaike information criterion (AIC).
}
}
\description{
Each observation is assumed to be the product of a Gamma(alpha, beta) and 
Lognormal(mu, sigsq) random variable. Performs maximization via 
\code{\link[stats]{nlminb}}. alpha and beta correspond to the shape and scale 
(not shape and rate) parameters described in \code{\link[stats]{GammaDist}}, 
and mu and sigsq correspond to meanlog and sdlog^2 in 
\code{\link[stats]{Lognormal}}.
}
\examples{
# Generate 1,000 values from Gamma(0.5, 1) x Lognormal(-1.5/2, 1.5) and 
# estimate parameters
\dontrun{
set.seed(123)
x <- rgamma(1000, 0.5, 1) * rlnorm(1000, -1.5/2, sqrt(1.5))
mle_gamma_lnorm(x, control = list(trace = 1))
}


}
