% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mean_i}
\alias{mean_i}
\title{Mean of Integer Values}
\usage{
mean_i(x)
}
\arguments{
\item{x}{Integer vector or matrix.}
}
\value{
Numeric value.
}
\description{
Written in C++, this function should always run faster than 
\code{\link[base]{mean}} for integer vectors/matrices. Not valid for 
non-integer objects.
}
\examples{
# For integer objects, mean_i is typically much faster than mean.
x <- rpois(100, lambda = 5)
mean(x) == mean_i(x)
benchmark(mean(x), mean_i(x), replications = 10000)

}
