# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Sample Covariance for Integer Vectors
#' 
#' Written in C++, this function should always run faster than 
#' \code{\link[stats]{cov}} for integer vectors. Will give incorrect result for 
#' non-integer vectors, and does not check that \code{x} and \code{y} are 
#' same length or that they contain no missing values.
#' 
#' @param x,y Integer vector.
#' 
#' @return Numeric value.
#' 
#' @examples
#' # For integer vectors, cov_i is typically much faster than cov.
#' x <- rpois(1000, lambda = 5)
#' y <- rpois(1000, lambda = 5)
#' all.equal(cov(x, y), cov_i(x, y))
#' benchmark(cov(x, y), cov_i(x, y), replications = 5000)
#' 
#' @export
cov_i <- function(x, y) {
    .Call(`_dvmisc_cov_i`, x, y)
}

#' Sample Covariance for Numeric Vectors
#' 
#' Written in C++, this function should always run faster than 
#' \code{\link[stats]{cov}} for numeric vectors. For integer vectors, 
#' \code{\link{cov_i}} should run even faster.
#' 
#' @param x,y Numeric vector.
#' 
#' @return Numeric value.
#' 
#' @examples 
#' # In general, cov_n is much faster than cov
#' x <- rnorm(1000)
#' y <- rnorm(1000)
#' all.equal(cov(x, y), cov_n(x, y))
#' benchmark(cov(x, y), cov_n(x, y), replications = 5000)
#' 
#' # For integer vectors, cov_i should be even faster.
#' x <- rpois(1000, lambda = 5)
#' y <- rpois(1000, lambda = 5)
#' all.equal(cov(x, y), cov_i(x, y))
#' benchmark(cov(x, y), cov_n(x, y), cov_i(x, y), replications = 5000)
#' 
#' @export
cov_n <- function(x, y) {
    .Call(`_dvmisc_cov_n`, x, y)
}

#' Lagged Differences for Integer Values
#' 
#' Written in C++, this function should always run faster than 
#' \code{\link[base]{diff}} for calculating lagged differences for an integer 
#' vector.
#' 
#' @param x Integer vector.
#' @param lag Integer value.
#' 
#' @return Integer vector.
#' 
#' @examples 
#' # diff_i is typically much faster than diff
#' x <- rpois(1000, lambda = 5)
#' all.equal(diff(x, 2), diff_i(x, 2))
#' benchmark(diff(x, 2), diff_i(x, 2), replications = 2000)
#' 
#' @export
diff_i <- function(x, lag = 1L) {
    .Call(`_dvmisc_diff_i`, x, lag)
}

#' Lagged Differences for Numeric Values
#' 
#' Written in C++, this function should always run faster than 
#' \code{\link[base]{diff}} for calculating lagged differences for a numeric 
#' vector. For integer vectors, \code{\link{diff_i}} should run even faster. 
#' even faster. 
#' 
#' @param x Numeric vector.
#' @param lag Integer value.
#' 
#' @return Numeric vector.
#' 
#' @examples 
#' # In general, diff_n is much faster than diff
#' x <- rnorm(1000)
#' all.equal(diff(x, 2), diff_n(x, 2))
#' benchmark(diff(x, 2), diff_n(x, 2), replications = 2000)
#' 
#' # For integer vectors, diff_i should be even faster
#' x <- rpois(1000, lambda = 5)
#' all.equal(diff(x, 2), diff_i(x, 2))
#' benchmark(diff(x, 2), diff_n(x, 2), diff_i(x, 2), replications = 2000)
#' 
#' @export
diff_n <- function(x, lag = 1L) {
    .Call(`_dvmisc_diff_n`, x, lag)
}

#' 1-Unit Lagged Differences for Integer Values
#' 
#' Written in C++, this function should always run faster than 
#' \code{\link[base]{diff}} for calculating differences between adjacent values 
#' of an integer vector.
#' 
#' @param x Integer vector.
#' 
#' @return Integer vector.
#' 
#' @examples 
#' # diff1_i is typically much faster than diff
#' x <- rpois(1000, lambda = 5)
#' all.equal(diff(x), diff1_i(x))
#' benchmark(diff(x), diff1_i(x), replications = 2000)
#' 
#' @export
diff1_i <- function(x) {
    .Call(`_dvmisc_diff1_i`, x)
}

#' 1-Unit Lagged Differences for Numeric Values
#' 
#' Written in C++, this function should always run faster than 
#' \code{\link[base]{diff}} for calculating differences between adjacent values 
#' of a numeric vector. For integer vectors, \code{\link{diff1_i}} should run 
#' even faster. 
#' 
#' @param x Numeric vector.
#' 
#' @return Numeric vector.
#' 
#' @examples 
#' # In general, diff1_n is much faster than diff
#' x <- rnorm(1000)
#' all.equal(diff(x), diff1_n(x))
#' benchmark(diff(x), diff1_n(x), replications = 3000)
#' 
#' # For integer vectors, diff1_i should be even faster
#' x <- rpois(1000, lambda = 5)
#' all.equal(diff(x), diff1_i(x))
#' benchmark(diff(x), diff1_n(x), diff1_i(x), replications = 3000)
#' 
#' @export
diff1_n <- function(x) {
    .Call(`_dvmisc_diff1_n`, x)
}

#' Maximum of Numeric Values
#' 
#' Written in C++, this function tends to run faster than 
#' \code{\link[base]{max}} for large numeric vectors/matrices.
#' 
#' @param x Numeric vector.
#' 
#' @return Numeric value.
#' 
#' @examples
#' # For large objects, max_n is faster than max
#' x <- rnorm(100000)
#' max(x) == max_n(x)
#' benchmark(max(x), max_n(x), replications = 1000)
#' 
#' # For smaller objects, max_n is slower than max
#' x <- rnorm(100)
#' max(x) == max_n(x)
#' benchmark(max(x), max_n(x), replications = 1000)
#' 
#' @export
max_n <- function(x) {
    .Call(`_dvmisc_max_n`, x)
}

#' Mean of Integer Values
#' 
#' Written in C++, this function should always run faster than 
#' \code{\link[base]{mean}} for integer vectors/matrices. Not valid for 
#' non-integer objects.
#' 
#' @param x Integer vector or matrix.
#' 
#' @return Numeric value.
#' 
#' @examples 
#' # For integer objects, mean_i is typically much faster than mean.
#' x <- rpois(100, lambda = 5)
#' mean(x) == mean_i(x)
#' benchmark(mean(x), mean_i(x), replications = 10000)
#' 
#' @export
mean_i <- function(x) {
    .Call(`_dvmisc_mean_i`, x)
}

#' Minimum of Numeric Values
#' 
#' Written in C++, this function tends to run faster than 
#' \code{\link[base]{min}} for large numeric vectors/matrices.
#' 
#' @param x Numeric vector.
#' 
#' @return Numeric value.
#' 
#' @examples
#' # For large objects, min_n is faster than min
#' x <- rnorm(100000)
#' min(x) == min_n(x)
#' benchmark(min(x), min_n(x), replications = 1000)
#' 
#' # For smaller objects, min_n is slower than min
#' x <- rnorm(100)
#' min(x) == min_n(x)
#' benchmark(min(x), min_n(x), replications = 20000)
#' 
#' @export
min_n <- function(x) {
    .Call(`_dvmisc_min_n`, x)
}

#' Range (Actually Minimum and Maximum) of Integer Values
#' 
#' Written in C++, this function should always run faster than 
#' \code{\link[base]{range}} for integer vectors/matrices. Not valid for 
#' non-integer objects.
#' 
#' @param x Integer vector or matrix.
#' 
#' @return Integer vector.
#' 
#' @examples 
#' # In general, range_i is much faster than range
#' x <- rpois(1000, lambda = 5) 
#' all.equal(range(x), range_i(x))
#' benchmark(range(x), range_i(x), replications = 10000)
#' 
#' @export
range_i <- function(x) {
    .Call(`_dvmisc_range_i`, x)
}

#' Range (Actually Minimum and Maximum) of Numeric Values
#' 
#' Written in C++, this function should always run faster than 
#' \code{\link[base]{range}} for numeric vectors/matrices. For integer objects, 
#' \code{\link{range_i}} should run even faster. 
#' 
#' @param x Numeric vector or matrix.
#' 
#' @return Numeric vector.
#' 
#' @examples 
#' # In general, range_n is much faster than range
#' x <- rnorm(1000)
#' all.equal(range(x), range_n(x))
#' benchmark(range(x), range_n(x), replications = 5000)
#' 
#' # For integer vectors, range_i should be even faster
#' x <- rpois(1000, lambda = 5) 
#' all.equal(range(x), range_i(x))
#' benchmark(range(x), range_n(x), range_i(x), replications = 10000)
#' 
#' @export
range_n <- function(x) {
    .Call(`_dvmisc_range_n`, x)
}

#' Sum of Integer Values
#' 
#' Written in C++, this function runs faster than \code{\link[base]{sum}} for 
#' large integer vectors/matrices. 
#' 
#' @param x Integer vector or matrix.
#' 
#' @return Numeric value.
#' 
#' @examples
#' # For very large integer objects, sum_i is faster than sum
#' x <- rpois(100000, lambda = 5)
#' sum(x) == sum_i(x)
#' benchmark(sum(x), sum_i(x), replications = 1000)
#' 
#' # For smaller integer objects, sum_i is slower than sum 
#' x <- rpois(1000, lambda = 5)
#' sum(x) == sum_i(x)
#' benchmark(sum(x), sum_i(x), replications = 1000)
#' 
#' @export
sum_i <- function(x) {
    .Call(`_dvmisc_sum_i`, x)
}

#' True Range of Integer Values
#' 
#' Defined as the difference between the maximum and the minimum. Equivalent to 
#' base R code \code{diff(range(x))}, but much faster.
#' 
#' @param x Integer vector or matrix.
#' 
#' @return Integer value.
#' 
#' @examples 
#' # In general, true_range_i is much faster than diff(range(x))
#' x <- rpois(1000, lambda = 5)
#' all.equal(diff(range(x)), true_range_i(x))
#' benchmark(diff(range(x)), true_range_i(x), replications = 5000)
#' 
#' @export
true_range_i <- function(x) {
    .Call(`_dvmisc_true_range_i`, x)
}

#' True Range of Numeric Values
#' 
#' Defined as the difference between the maximum and the minimum. Equivalent to 
#' base R code \code{diff(range(x))}, but much faster. For integer objects, 
#' \code{\link{true_range_i}} should run even faster.
#' 
#' @param x Numeric vector or matrix.
#' 
#' @return Numeric value.
#' 
#' @examples 
#' # In general, true_range_n is much faster than diff(range(x))
#' x <- rnorm(1000)
#' all.equal(diff(range(x)), true_range_n(x))
#' benchmark(diff(range(x)), true_range_n(x), replications = 5000)
#' 
#' # For integer vectors, true_range_i should be even faster
#' x <- rpois(1000, lambda = 5)
#' all.equal(diff(range(x)), true_range_i(x))
#' benchmark(diff(range(x)), true_range_n(x), true_range_i(x), 
#'           replications = 5000)
#' 
#' @export
true_range_n <- function(x) {
    .Call(`_dvmisc_true_range_n`, x)
}

#' Sample Variance for Integer Values
#' 
#' Written in C++, this function should always run faster than 
#' \code{\link[stats]{var}} for integer vectors. Not valid for non-integer 
#' input vectors.
#' 
#' @param x Integer vector.
#' 
#' @return Numeric value.
#' 
#' @examples 
#' # For integer vectors, var_i is typically much faster than var.
#' x <- rpois(1000, lambda = 5)
#' all.equal(var(x), var_i(x))
#' benchmark(var(x), var_i(x), replications = 5000)
#' 
#' @export
var_i <- function(x) {
    .Call(`_dvmisc_var_i`, x)
}

#' Sample Variance for Numeric Values
#' 
#' Written in C++, this function should always run faster than 
#' \code{\link[stats]{var}} for numeric vectors. For integer vectors, 
#' \code{\link{var_i}} should run even faster.
#' 
#' @param x Numeric vector.
#' 
#' @return Numeric value.
#' 
#' @examples 
#' # In general, var_n is much faster than var.
#' x <- rnorm(1000)
#' all.equal(var(x), var_n(x))
#' benchmark(var(x), var_n(x), replications = 1000)
#' 
#' # For integer vectors, var_i should be even faster.
#' x <- rpois(1000, lambda = 5)
#' all.equal(var(x), var_i(x))
#' benchmark(var(x), var_n(x), var_i(x), replications = 1000)
#' 
#' @export
var_n <- function(x) {
    .Call(`_dvmisc_var_n`, x)
}

#' Weighted Arithmetic Mean for Integer Values and Integer Weights
#' 
#' Written in C++, this function should always run faster than 
#' \code{\link{weighted.mean}}.
#' 
#' For optimal speed, choose the version of this function that matches the 
#' class of your \code{x} and \code{w}: 
#' \code{\link{weighted_mean_nn}} for numeric \code{x}, numeric \code{w} \cr 
#' \code{\link{weighted_mean_ni}} for numeric \code{x}, integer \code{w} \cr 
#' \code{\link{weighted_mean_in}} for integer \code{x}, numeric \code{w} \cr 
#' \code{\link{weighted_mean_ii}} for integer \code{x}, integer \code{w} \cr
#' 
#' These functions typically execute several times faster than the base R 
#' function \code{\link[stats]{weighted.mean}} and weighted average functions 
#' in other packages (e.g. \code{wtd.mean} in \pkg{Hmisc} and \code{wt.mean} in 
#' \pkg{SDMTools}).
#' 
#' @param x Integer vector of values.
#' @param w Integer vector of weights.
#' 
#' @return Numeric value.
#' 
#' @examples 
#' # weighted_mean_ii is typically much faster than weighted.mean
#' x <- rpois(1000, lambda = 5)
#' w <- rpois(1000, lambda = 5)
#' all.equal(weighted.mean(x, w), weighted_mean_ii(x, w))
#' benchmark(weighted.mean(x, w), weighted_mean_ii(x, w), replications = 2000)
#' 
#' @export
weighted_mean_ii <- function(x, w) {
    .Call(`_dvmisc_weighted_mean_ii`, x, w)
}

#' Weighted Arithmetic Mean for Integer Values and Numeric Weights
#' 
#' Written in C++, this function should always run faster than 
#' \code{\link[stats]{weighted.mean}}.
#' 
#' For optimal speed, choose the version of this function that matches the 
#' class of your \code{x} and \code{w}: 
#' \code{\link{weighted_mean_nn}} for numeric \code{x}, numeric \code{w} \cr 
#' \code{\link{weighted_mean_ni}} for numeric \code{x}, integer \code{w} \cr 
#' \code{\link{weighted_mean_in}} for integer \code{x}, numeric \code{w} \cr 
#' \code{\link{weighted_mean_ii}} for integer \code{x}, integer \code{w} \cr
#' 
#' These functions typically execute several times faster than the base R 
#' function \code{\link[stats]{weighted.mean}} and weighted average functions 
#' in other packages (e.g. \code{wtd.mean} in \pkg{Hmisc} and \code{wt.mean} in 
#' \pkg{SDMTools}).
#' 
#' @param x Integer vector of values.
#' @param w Numeric vector of weights.
#' 
#' @return Numeric value.
#' 
#' @examples 
#' # weighted_mean_in is typically much faster than weighted.mean
#' x <- rpois(1000, lambda = 5)
#' w <- runif(1000)
#' all.equal(weighted.mean(x, w), weighted_mean_in(x, w))
#' benchmark(weighted.mean(x, w), weighted_mean_in(x, w), replications = 2000)
#' 
#' @export
weighted_mean_in <- function(x, w) {
    .Call(`_dvmisc_weighted_mean_in`, x, w)
}

#' Weighted Arithmetic Mean for Numeric Values and Integer Weights
#' 
#' Written in C++, this function should always run faster than 
#' \code{\link[stats]{weighted.mean}}.
#' 
#' For optimal speed, choose the version of this function that matches the 
#' class of your \code{x} and \code{w}: 
#' \code{\link{weighted_mean_nn}} for numeric \code{x}, numeric \code{w} \cr 
#' \code{\link{weighted_mean_ni}} for numeric \code{x}, integer \code{w} \cr 
#' \code{\link{weighted_mean_in}} for integer \code{x}, numeric \code{w} \cr 
#' \code{\link{weighted_mean_ii}} for integer \code{x}, integer \code{w} \cr
#' 
#' These functions typically execute several times faster than the base R 
#' function \code{\link[stats]{weighted.mean}} and weighted average functions 
#' in other packages (e.g. \code{wtd.mean} in \pkg{Hmisc} and \code{wt.mean} in 
#' \pkg{SDMTools}).
#' 
#' @param x Numeric vector of values.
#' @param w Integer vector of weights.
#' 
#' @return Numeric value.
#' 
#' @examples 
#' # weighted_mean_ni is typically much faster than weighted.mean 
#' x <- rnorm(1000)
#' w <- rpois(1000, lambda = 5)
#' all.equal(weighted.mean(x, w), weighted_mean_ni(x, w))
#' benchmark(weighted.mean(x, w), weighted_mean_ni(x, w), replications = 2000)
#' 
#' @export
weighted_mean_ni <- function(x, w) {
    .Call(`_dvmisc_weighted_mean_ni`, x, w)
}

#' Weighted Arithmetic Mean for Numeric Values and Numeric Weights
#' 
#' Written in C++, this function should always run faster than 
#' \code{\link[stats]{weighted.mean}}.
#' 
#' For optimal speed, choose the version of this function that matches the 
#' class of your \code{x} and \code{w}: 
#' \code{\link{weighted_mean_nn}} for numeric \code{x}, numeric \code{w} \cr 
#' \code{\link{weighted_mean_ni}} for numeric \code{x}, integer \code{w} \cr 
#' \code{\link{weighted_mean_in}} for integer \code{x}, numeric \code{w} \cr 
#' \code{\link{weighted_mean_ii}} for integer \code{x}, integer \code{w} \cr
#' 
#' These functions typically execute several times faster than the base R 
#' function \code{\link[stats]{weighted.mean}} and weighted average functions 
#' in other packages (e.g. \code{wtd.mean} in \pkg{Hmisc} and \code{wt.mean} in 
#' \pkg{SDMTools}).
#' 
#' @param x Numeric vector of values.
#' @param w Numeric vector of weights.
#' 
#' @return Numeric value.
#' 
#' @examples 
#' # weighted_mean_nn is typically much faster than weighted.mean
#' x <- rnorm(1000)
#' w <- runif(1000)
#' all.equal(weighted.mean(x, w), weighted_mean_nn(x, w))
#' benchmark(weighted.mean(x, w), weighted_mean_nn(x, w), replications = 2000)
#' 
#' @export
weighted_mean_nn <- function(x, w) {
    .Call(`_dvmisc_weighted_mean_nn`, x, w)
}

#' Return (Row, Column) Index of (First) Maximum of an Integer Matrix
#' 
#' Written in C++, this function tends to run much faster than the equivalent 
#' (if maximum is unique) base R solution 
#' \code{which(x == max(x), arr.ind = TRUE)}.
#' 
#' For optimal speed, choose the version of this function that matches the 
#' class of your \code{x}:
#' 
#' \code{\link{which_max_nv}} for numeric vector. \cr
#' \code{\link{which_max_iv}} for integer vector. \cr
#' \code{\link{which_max_nm}} for numeric matrix. \cr
#' \code{\link{which_max_im}} for integer matrix.
#' 
#' @param x Integer matrix.
#' 
#' @return Integer vector.
#' 
#' @examples 
#' # which_max_im is typically much faster than 
#' # which(x == max(x), arr.ind = TRUE)
#' x <- matrix(rpois(100, lambda = 15), ncol = 10)
#' all(which(x == max(x), arr.ind = TRUE) == which_max_im(x))
#' benchmark(which(x == max(x), arr.ind = TRUE), which_max_im(x), 
#'           replications = 5000)
#' 
#' @export
which_max_im <- function(x) {
    .Call(`_dvmisc_which_max_im`, x)
}

#' Return Index of (First) Maximum of an Integer Vector
#' 
#' Written in C++, this function tends to run faster than 
#' \code{\link[base]{which.max}} for large integer vectors.
#' 
#' For optimal speed, choose the version of this function that matches the 
#' class of your \code{x}:
#' 
#' \code{\link{which_max_nv}} for numeric vector. \cr
#' \code{\link{which_max_iv}} for integer vector. \cr
#' \code{\link{which_max_nm}} for numeric matrix. \cr
#' \code{\link{which_max_im}} for integer matrix.
#' 
#' @param x Integer vector.
#' 
#' @return Integer value.
#' 
#' @examples 
#' # For long vectors, which_max_iv is faster than which.max
#' x <- rpois(10000, lambda = 15)
#' which.max(x) == which_max_iv(x)
#' benchmark(which.max(x), which_max_iv(x), replications = 5000)
#' 
#' # For shorter vectors, which_max_iv is slower than which.max
#' x <- rpois(100, lambda = 15)
#' which.max(x) == which_max_iv(x)
#' benchmark(which.max(x), which_max_iv(x), replications = 20000)
#' 
#' @export
which_max_iv <- function(x) {
    .Call(`_dvmisc_which_max_iv`, x)
}

#'Return (Row, Column) Index of (First) Maximum of a Numeric Matrix
#' 
#' Written in C++, this function tends to run much faster than the equivalent 
#' (if maximum is unique) base R solution 
#' \code{which(x == max(x), arr.ind = TRUE)}.
#' 
#' For optimal speed, choose the version of this function that matches the 
#' class of your \code{x}:
#' 
#' \code{\link{which_max_nv}} for numeric vector. \cr
#' \code{\link{which_max_iv}} for integer vector. \cr
#' \code{\link{which_max_nm}} for numeric matrix. \cr
#' \code{\link{which_max_im}} for integer matrix.
#' 
#' @param x Numeric matrix.
#' 
#' @return Integer vector.
#' 
#' @examples 
#' # which_max_nm is typically much faster than 
#' # which(x == max(x), arr.ind = TRUE)
#' x <- matrix(rnorm(100), ncol = 10)
#' all(which(x == max(x), arr.ind = TRUE) == which_max_nm(x))
#' benchmark(which(x == max(x), arr.ind = TRUE), which_max_nm(x),
#'           replications = 5000)
#' 
#' @export
which_max_nm <- function(x) {
    .Call(`_dvmisc_which_max_nm`, x)
}

#' Return Index of (First) Maximum of a Numeric Vector
#' 
#' Written in C++, this function tends to run faster than 
#' \code{\link[base]{which.max}} for large numeric vectors.
#' 
#' For optimal speed, choose the version of this function that matches the 
#' class of your \code{x}:
#' 
#' \code{\link{which_max_nv}} for numeric vector. \cr
#' \code{\link{which_max_iv}} for integer vector. \cr
#' \code{\link{which_max_nm}} for numeric matrix. \cr
#' \code{\link{which_max_im}} for integer matrix.
#' 
#' @param x Numeric vector.
#' 
#' @return Integer value.
#' 
#' @examples 
#' # For long vectors, which_max_nv is faster than which.max
#' x <- rnorm(100000)
#' which.max(x) == which_max_nv(x)
#' benchmark(which.max(x), which_max_nv(x), replications = 500)
#' 
#' # For shorter vectors, which_max_nv is slower than which.max
#' x <- rnorm(100)
#' which.max(x) == which_max_nv(x)
#' benchmark(which.max(x), which_max_nv(x), replications = 10000)
#' 
#' @export
which_max_nv <- function(x) {
    .Call(`_dvmisc_which_max_nv`, x)
}

#' Return (Row, Column) Index of (First) Minimum of an Integer Matrix
#' 
#' Written in C++, this function tends to run much faster than the equivalent 
#' (if minimum is unique) base R solution 
#' \code{which(x == min(x), arr.ind = TRUE)}.
#' 
#' For optimal speed, choose the version of this function that matches the 
#' class of your \code{x}:
#' 
#' \code{\link{which_min_nv}} for numeric vector. \cr
#' \code{\link{which_min_iv}} for integer vector. \cr
#' \code{\link{which_min_nm}} for numeric matrix. \cr
#' \code{\link{which_min_im}} for integer matrix.
#' 
#' @param x Integer matrix.
#' 
#' @return Integer vector.
#' 
#' @examples 
#' # which_min_im is typically much faster than 
#' # which(x == min(x), arr.ind = TRUE)
#' x <- matrix(rpois(100, lambda = 10), ncol = 10)
#' all(which(x == min(x), arr.ind = TRUE) == which_min_im(x))
#' benchmark(which(x == min(x), arr.ind = TRUE), which_min_im(x),
#'           replications = 5000)
#' 
#' @export
which_min_im <- function(x) {
    .Call(`_dvmisc_which_min_im`, x)
}

#' Return Index of (First) Minimum of an Integer Vector
#' 
#' Written in C++, this function tends to run faster than 
#' \code{\link{which.min}} for large integer vectors.
#' 
#' For optimal speed, choose the version of this function that matches the 
#' class of your \code{x}:
#' 
#' \code{\link{which_min_nv}} for numeric vector. \cr
#' \code{\link{which_min_iv}} for integer vector. \cr
#' \code{\link{which_min_nm}} for numeric matrix. \cr
#' \code{\link{which_min_im}} for integer matrix.
#' 
#' @param x Integer vector.
#' 
#' @return Integer value.
#' 
#' @examples 
#' # For long vectors, which_min_iv is faster than which.min 
#' x <- rpois(10000, lambda = 15)
#' which.min(x) == which_min_iv(x)
#' benchmark(which.min(x), which_min_iv(x), replications = 5000)
#' 
#' # For shorter vectors, which_min_iv is slower than which.min
#' x <- rpois(100, lambda = 15)
#' which.min(x) == which_min_iv(x)
#' benchmark(which.min(x), which_min_iv(x), replications = 20000)
#' 
#' @export
which_min_iv <- function(x) {
    .Call(`_dvmisc_which_min_iv`, x)
}

#' Return (Row, Column) Index of (First) Minimum of a Numeric Matrix
#' 
#' Written in C++, this function tends to run much faster than the equivalent 
#' (if minimum is unique) base R solution 
#' \code{which(x == min(x), arr.ind = TRUE)}.
#' 
#' For optimal speed, choose the version of this function that matches the 
#' class of your \code{x}:
#' 
#' \code{\link{which_min_nv}} for numeric vector. \cr
#' \code{\link{which_min_iv}} for integer vector. \cr
#' \code{\link{which_min_nm}} for numeric matrix. \cr
#' \code{\link{which_min_im}} for integer matrix.
#' 
#' @param x Numeric matrix.
#' 
#' @return Integer vector.
#' 
#' @examples 
#' # which_min_nm is typically much faster than 
#' # which(x == min(x), arr.ind = TRUE)
#' x <- matrix(rnorm(100), ncol = 10)
#' all(which(x == min(x), arr.ind = TRUE) == which_min_nm(x))
#' benchmark(which(x == min(x), arr.ind = TRUE), which_min_nm(x), 
#'           replications = 5000)
#' 
#' @export
which_min_nm <- function(x) {
    .Call(`_dvmisc_which_min_nm`, x)
}

#' Return Index of (First) Minimum of a Numeric Vector
#' 
#' Written in C++, this function tends to run faster than 
#' \code{\link[base]{which.min}} for large numeric vectors.
#' 
#' For optimal speed, choose the version of this function that matches the 
#' class of your \code{x}:
#' 
#' \code{\link{which_min_nv}} for numeric vector. \cr
#' \code{\link{which_min_iv}} for integer vector. \cr
#' \code{\link{which_min_nm}} for numeric matrix. \cr
#' \code{\link{which_min_im}} for integer matrix.
#' 
#' @param x Numeric vector.
#' 
#' @return Integer value.
#' 
#' @examples 
#' # For long vectors, which_min_nv is faster than which.min
#' x <- rnorm(100000)
#' which.min(x) == which_min_nv(x)
#' benchmark(which.min(x), which_min_nv(x), replications = 1000)
#' 
#' # For shorter vectors, which_min_nv is slower than which.min
#' x <- rnorm(100)
#' which.min(x) == which_min_nv(x)
#' benchmark(which.min(x), which_min_nv(x), replications = 10000)
#' 
#' @export
which_min_nv <- function(x) {
    .Call(`_dvmisc_which_min_nv`, x)
}

