% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{diff_n}
\alias{diff_n}
\title{Lagged Differences for Numeric Values}
\usage{
diff_n(x, lag = 1L)
}
\arguments{
\item{x}{Numeric vector.}

\item{lag}{Integer value.}
}
\value{
Numeric vector.
}
\description{
Written in C++, this function should always run faster than 
\code{\link[base]{diff}} for calculating lagged differences for a numeric 
vector. For integer vectors, \code{\link{diff_i}} should run even faster. 
even faster.
}
\examples{
# In general, diff_n is much faster than diff
x <- rnorm(1000)
all.equal(diff(x, 2), diff_n(x, 2))
benchmark(diff(x, 2), diff_n(x, 2), replications = 2000)

# For integer vectors, diff_i should be even faster
x <- rpois(1000, lambda = 5)
all.equal(diff(x, 2), diff_i(x, 2))
benchmark(diff(x, 2), diff_n(x, 2), diff_i(x, 2), replications = 2000)

}
