# Generated by 02-duckplyr_df-methods.R
#' @export
cross_join.duckplyr_df <- function(x, y, ..., copy = FALSE, suffix = c(".x", ".y")) {
  # Our implementation
  duckplyr_error <- rel_try(NULL,
    "No relational implementation for {.code cross_join()}" = TRUE,
    {
      return(out)
    }
  )

  # dplyr forward
  check_prudence(x, duckplyr_error)

  cross_join <- dplyr$cross_join.data.frame
  out <- cross_join(x, y, ..., copy = copy, suffix = suffix)
  return(out)

  # dplyr implementation
  check_dots_empty0(...)

  y <- auto_copy(x, y, copy = copy)

  x_names <- tbl_vars(x)
  y_names <- tbl_vars(y)

  # Empty join by with no keys
  by <- new_join_by()

  # Particular value isn't too important, as there are no keys to keep/drop
  keep <- FALSE

  vars <- join_cols(
    x_names = x_names,
    y_names = y_names,
    by = by,
    suffix = suffix,
    keep = keep
  )

  x_in <- as_tibble(x, .name_repair = "minimal")
  y_in <- as_tibble(y, .name_repair = "minimal")

  x_size <- vec_size(x_in)
  y_size <- vec_size(y_in)

  x_out <- set_names(x_in, names(vars$x$out))
  y_out <- set_names(y_in, names(vars$y$out))

  x_out <- vec_rep_each(x_out, times = y_size)
  y_out <- vec_rep(y_out, times = x_size)

  x_out[names(y_out)] <- y_out

  dplyr_reconstruct(x_out, x)
}

duckplyr_cross_join <- function(x, y, ...) {
  try_fetch(
    {
      x <- as_duckplyr_df_impl(x)
      y <- as_duckplyr_df_impl(y)
    },
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- cross_join(x, y, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
