% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_duckplyr_df.R, R/as_duckplyr_tibble.R
\name{as_duckplyr_df}
\alias{as_duckplyr_df}
\alias{as_duckplyr_tibble}
\title{Convert to a duckplyr data frame}
\usage{
as_duckplyr_df(.data)

as_duckplyr_tibble(.data)
}
\arguments{
\item{.data}{data frame or tibble to transform}
}
\value{
For \code{as_duckplyr_df()}, an object of class \code{"duckplyr_df"},
inheriting from the classes of the \code{.data} argument.

For \code{as_duckplyr_df()}, an object of class
\code{c("duckplyr_df", class(tibble()))} .
}
\description{
These functions convert a data-frame-like input to an object of class \code{"duckpylr_df"}.
For such objects,
dplyr verbs such as \code{\link[=mutate]{mutate()}}, \code{\link[=select]{select()}} or \code{\link[=filter]{filter()}}  will attempt to use DuckDB.
If this is not possible, the original dplyr implementation is used.

\code{as_duckplyr_df()} requires the input to be a plain data frame or a tibble,
and will fail for any other classes, including subclasses of \code{"data.frame"} or \code{"tbl_df"}.
This behavior is likely to change, do not rely on it.

\code{as_duckplyr_tibble()} converts the input to a tibble and then to a duckplyr data frame.
}
\details{
Set the \code{DUCKPLYR_FALLBACK_INFO} and \code{DUCKPLYR_FORCE} environment variables
for more control over the behavior, see \link{config} for more details.
}
\examples{
tibble(a = 1:3) \%>\%
  mutate(b = a + 1)

tibble(a = 1:3) \%>\%
  as_duckplyr_df() \%>\%
  mutate(b = a + 1)
}
