# Generated by 02-duckplyr_df-methods.R
#' @export
group_by.duckplyr_df <- function(.data, ..., .add = FALSE, .drop = group_by_drop_default(.data)) {
  # Our implementation
  rel_try(
    # Always fall back to dplyr
    "No relational implementation for group_by()" = TRUE,
    {
      return(out)
    }
  )

  # dplyr forward
  group_by <- dplyr$group_by.data.frame
  out <- group_by(.data, ..., .add = .add, .drop = .drop)
  return(out)

  # dplyr implementation
  groups <- group_by_prepare(
    .data,
    ...,
    .add = .add,
    error_call = current_env()
  )
  grouped_df(groups$data, groups$group_names, .drop)
}

duckplyr_group_by <- function(.data, ...) {
  try_fetch(
    .data <- as_duckplyr_df(.data),
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- group_by(.data, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
