% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relational-rel.R
\name{relational}
\alias{relational}
\alias{new_relational}
\alias{rel_to_df}
\alias{rel_filter}
\alias{rel_project}
\alias{rel_aggregate}
\alias{rel_order}
\alias{rel_join}
\alias{rel_limit}
\alias{rel_distinct}
\alias{rel_set_intersect}
\alias{rel_set_diff}
\alias{rel_set_symdiff}
\alias{rel_union_all}
\alias{rel_names}
\title{Relational implementer's interface}
\usage{
new_relational(..., class = NULL)

rel_to_df(rel, ...)

rel_filter(rel, exprs, ...)

rel_project(rel, exprs, ...)

rel_aggregate(rel, groups, aggregates, ...)

rel_order(rel, orders, ...)

rel_join(
  left,
  right,
  conds,
  join = c("inner", "left", "right", "outer", "cross", "semi", "anti"),
  ...
)

rel_limit(rel, n, ...)

rel_distinct(rel, ...)

rel_set_intersect(rel_a, rel_b, ...)

rel_set_diff(rel_a, rel_b, ...)

rel_set_symdiff(rel_a, rel_b, ...)

rel_union_all(rel_a, rel_b, ...)

rel_names(rel, ...)
}
\arguments{
\item{...}{Reserved for future extensions, must be empty.}

\item{class}{Classes added in front of the \code{"relational"} base class.}

\item{rel, rel_a, rel_b, left, right}{A relational object.}

\item{exprs}{A list of \link{expr} objects to filter by.}

\item{groups}{A list of expressions to group by.}

\item{aggregates}{A list of expressions with aggregates to compute.}

\item{orders}{A list of expressions to order by.}

\item{conds}{A list of expressions to use for the join.}

\item{join}{The type of join.}

\item{n}{The number of rows.}
}
\value{
\itemize{
\item \code{new_relational()} returns a new relational object.
\item \code{rel_to_df()} returns a data frame.
\item \code{rel_names()} returns a character vector.
\item All other generics return a modified relational object.
}
}
\description{
The constructor and generics described here define a class
that helps separating dplyr's user interface from the actual underlying operations.
In the longer term, this will help packages that implement the dplyr interface
(such as \pkg{dbplyr}, \pkg{dtplyr}, \pkg{arrow} and similar)
to focus on the core details of their functionality,
rather than on the intricacies of dplyr's user interface.

\code{new_relational()} constructs an object of class \code{"relational"}.
Users are encouraged to provide the \code{class} argument.
The typical use case will be to create a wrapper function.

\code{rel_to_df()} extracts a data frame representation from a relational object,
to be used by \code{\link[dplyr:compute]{dplyr::collect()}}.

\code{rel_filter()} keeps rows that match a predicate,
to be used by \code{\link[dplyr:filter]{dplyr::filter()}}.

\code{rel_project()} selects columns or creates new columns,
to be used by \code{\link[dplyr:select]{dplyr::select()}}, \code{\link[dplyr:rename]{dplyr::rename()}},
\code{\link[dplyr:mutate]{dplyr::mutate()}}, \code{\link[dplyr:relocate]{dplyr::relocate()}}, and others.

\code{rel_aggregate()} combines several rows into one,
to be used by \code{\link[dplyr:summarise]{dplyr::summarize()}}.

\code{rel_order()} reorders rows by columns or expressions,
to be used by \code{\link[dplyr:arrange]{dplyr::arrange()}}.

\code{rel_join()} joins or merges two tables,
to be used by \code{\link[dplyr:mutate-joins]{dplyr::left_join()}}, \code{\link[dplyr:mutate-joins]{dplyr::right_join()}},
\code{\link[dplyr:mutate-joins]{dplyr::inner_join()}}, \code{\link[dplyr:mutate-joins]{dplyr::full_join()}}, \code{\link[dplyr:cross_join]{dplyr::cross_join()}},
\code{\link[dplyr:filter-joins]{dplyr::semi_join()}}, and \code{\link[dplyr:filter-joins]{dplyr::anti_join()}}.

\code{rel_limit()} limits the number of rows in a table,
to be used by \code{\link[utils:head]{utils::head()}}.

\code{rel_distinct()} only keeps the distinct rows in a table,
to be used by \code{\link[dplyr:distinct]{dplyr::distinct()}}.

\code{rel_set_intersect()} returns rows present in both tables,
to be used by \code{\link[=intersect]{intersect()}}.

\code{rel_set_diff()} returns rows present in any of both tables,
to be used by \code{\link[=setdiff]{setdiff()}}.

\code{rel_set_symdiff()} returns rows present in any of both tables,
to be used by \code{\link[dplyr:setops]{dplyr::symdiff()}}.

\code{rel_union_all()} returns rows present in any of both tables,
to be used by \code{\link[dplyr:setops]{dplyr::union_all()}}.

\code{rel_names()} returns the column names as character vector,
to be used by \code{\link[=colnames]{colnames()}}.
}
\examples{
new_dfrel <- function(x) {
  stopifnot(is.data.frame(x))
  new_relational(list(x), class = "dfrel")
}
mtcars_rel <- new_dfrel(mtcars[1:5, 1:4])

rel_to_df.dfrel <- function(rel, ...) {
  unclass(rel)[[1]]
}
rel_to_df(mtcars_rel)
\dontshow{if ({ set.seed(20230630); TRUE }) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

rel_filter.dfrel <- function(rel, exprs, ...) {
  df <- unclass(rel)[[1]]

  # A real implementation would evaluate the predicates defined
  # by the exprs argument
  new_dfrel(df[sample.int(nrow(df), 3, replace = TRUE), ])
}

rel_filter(
  mtcars_rel,
  list(
    relexpr_function(
      "gt",
      list(relexpr_reference("cyl"), relexpr_constant("6"))
    )
  )
)
\dontshow{\}) # examplesIf}

rel_project.dfrel <- function(rel, exprs, ...) {
  df <- unclass(rel)[[1]]

  # A real implementation would evaluate the expressions defined
  # by the exprs argument
  new_dfrel(df[seq_len(min(3, ncol(df)))])
}

rel_project(
  mtcars_rel,
  list(relexpr_reference("cyl"), relexpr_reference("disp"))
)

rel_order.dfrel <- function(rel, exprs, ...) {
  df <- unclass(rel)[[1]]

  # A real implementation would evaluate the expressions defined
  # by the exprs argument
  new_dfrel(df[order(df[[1]]), ])
}

rel_order(
  mtcars_rel,
  list(relexpr_reference("mpg"))
)
\dontshow{if (requireNamespace("dplyr", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
rel_join.dfrel <- function(left, right, conds, join, ...) {
  left_df <- unclass(left)[[1]]
  right_df <- unclass(right)[[1]]

  # A real implementation would evaluate the expressions
  # defined by the conds argument,
  # use different join types based on the join argument,
  # and implement the join itself instead of relaying to left_join().
  new_dfrel(dplyr::left_join(left_df, right_df))
}

rel_join(new_dfrel(data.frame(mpg = 21)), mtcars_rel)
\dontshow{\}) # examplesIf}

rel_limit.dfrel <- function(rel, n, ...) {
  df <- unclass(rel)[[1]]

  new_dfrel(df[seq_len(n), ])
}

rel_limit(mtcars_rel, 3)

rel_distinct.dfrel <- function(rel, ...) {
  df <- unclass(rel)[[1]]

  new_dfrel(df[!duplicated(df), ])
}

rel_distinct(new_dfrel(mtcars[1:3, 1:4]))

rel_names.dfrel <- function(rel, ...) {
  df <- unclass(rel)[[1]]

  names(df)
}

rel_names(mtcars_rel)
}
