% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deidentify.R
\name{deid_dua}
\alias{deid_dua}
\title{Convert identifying variable to unique hash}
\usage{
deid_dua(
  df,
  id_col = NULL,
  new_id_name = "id",
  id_length = 64,
  existing_crosswalk = NULL,
  write_crosswalk = FALSE,
  crosswalk_filename = NULL
)
}
\arguments{
\item{df}{Data frame}

\item{id_col}{Column name with IDs to be replaced. By default it is
\code{NULL} and uses the value set by the \code{id_column}
argument in \code{set_dua_level()} function.}

\item{new_id_name}{New hashed ID column name, which must be
different from old name.}

\item{id_length}{Length of new hashed ID; cannot be fewer than 12
characters (default is 64 characters).}

\item{existing_crosswalk}{File name of existing crosswalk. If
existing crosswalk is used, then \code{new_id_name},
\code{id_length}, \code{id_length}, and \code{crosswalk_name}
will be determined by the already existing crosswalk. Arguments
given for these values will be ignored.}

\item{write_crosswalk}{Write crosswalk between old ID and new hash
ID to console (unless \code{crosswalk_name} is given value).}

\item{crosswalk_filename}{Name of crosswalk file with path;
defaults to generic name with current date (YYYYMMDD) appended.}
}
\description{
Convert a column of unique but restricted IDs into a set of new IDs
using secure (SHA-2) hashing algorithm. Users have the option of
saving a crosswalk between the old and new IDs in case observations
need to reidentified at a later date.
}
\examples{
## --------------
## Setup
## --------------
## set DUA crosswalk
dua_cw <- system.file('extdata', 'dua_cw.csv', package = 'duawranglr')
set_dua_cw(dua_cw)
## read in data
admin <- system.file('extdata', 'admin_data.csv', package = 'duawranglr')
df <- read_dua_file(admin)
## --------------

## show identified data
df

## deidentify
df <- deid_dua(df, id_col = 'sid', new_id_name = 'id', id_length = 12)

## show deidentified data
df

\dontrun{
## save crosswalk between old and new ids for future
deid_dua(df, write_crosswalk = TRUE)

## use existing crosswalk (good for panel datasets that need link)
deid_dua(df, existing_crosswalk = './crosswalk/master_crosswalk.csv')
}

}
