% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wday.R
\name{dtt_wday}
\alias{dtt_wday}
\alias{dtt_wday.default}
\title{Get Week Day}
\usage{
dtt_wday(x, abbr = FALSE, ...)

\method{dtt_wday}{default}(x, abbr = FALSE, ...)
}
\arguments{
\item{x}{A date/time vector.}

\item{abbr}{A flag specifying whether to abbreviate the week days.}

\item{...}{Unused.}
}
\value{
An character vector of the week days.
}
\description{
Gets the week days for the locale.
}
\section{Methods (by class)}{
\itemize{
\item \code{dtt_wday(default)}: Get character vector of week days for a Date vector

}}
\examples{
x <- as.Date("1990-01-02")
dtt_wday(x)

x <- as.POSIXct("1990-01-02 23:40:51")
dtt_wday(x, abbr = TRUE)
}
