% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dot.R
\name{save_dot}
\alias{save_dot}
\title{Save DOT content to a file}
\usage{
save_dot(
  dot,
  filename,
  size = std_size$half,
  maxWidth = size$width,
  maxHeight = size$height,
  rot = size$rot,
  formats = c("dot", "png", "pdf", "svg")
)
}
\arguments{
\item{dot}{\itemize{
\item a graphviz dot string
}}

\item{filename}{\itemize{
\item the full path of the filename (minus extension for multiple formats)
}}

\item{size}{\itemize{
\item a list of length and width in inches e.g. a std_size
}}

\item{maxWidth}{\itemize{
\item a width in inches is size is not defined
}}

\item{maxHeight}{\itemize{
\item a height in inches if size is not defined
}}

\item{rot}{\itemize{
\item an angle of rotation for the saved file if size is not defined
}}

\item{formats}{\itemize{
\item some of "pdf","dot","svg","png","ps"
}}
}
\value{
a list with items \code{paths} with the absolute paths of the saved files, and svg as the SVG string of the rendered dot file.
}
\description{
Convert a digraph in dot file to SVG and save it to an output file
}
\examples{
dot2svg("digraph {A->B} ")
}
