% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtable.R
\name{dtable}
\alias{dtable}
\title{Generate descriptive frequencies and statistics tables}
\usage{
dtable(data1, vars = NULL, frequencies = NULL, statistics = NULL,
  neat = TRUE, as.list = FALSE, sizesort = FALSE)
}
\arguments{
\item{data1}{a \code{data.frame} or \code{matrix}}

\item{vars}{select which columns of \code{data1} to analyze}

\item{frequencies}{select which columns to create frequencies tables for}

\item{statistics}{select which columns to create statistics tables for}

\item{neat}{logical, if \code{TRUE} returns rounded and formatted tables}

\item{as.list}{logical, if \code{TRUE} it returns frequencies and statistics
tables in a list format, split by \code{variables}}

\item{sizesort}{logical, if \code{TRUE} returns data sorted by frequency and
mean}
}
\value{
Returns descriptive frequencies and statistics tables for all
  variables in \code{data1} by default. Predicts whether to create a
  frequencies table, statistics table, or both for each varible based on
  information gathered using \code{dvariable}.
}
\description{
Simplifies the process and reduces the amount of code involved in generating
descriptive frequencies and statistics tables by taking your entire dataset
as input and generating the tables it predicts you would need given various
variable aspects such as class.
}
\examples{
# Analyze all data
dtable(iris2)

#Analyze two or more variables
dtable(iris2, vars = c("Color", "Sold", "LikelyToBuy"))

# Analyze a single variable
dtable(iris2, vars = "Color")

# Return raw output
dtable(iris2, neat = FALSE)

# Return list output
dtable(iris2, as.list = TRUE)

# Frequencies sorted by size
dtable(iris2, sizesort = TRUE)

}

