% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class.Constructors.R
\name{make.coverage}
\alias{make.coverage}
\title{Creates a Coverage.Grid object}
\usage{
make.coverage(region = make.region(), spacing = numeric(0),
  n.grid.points = 1000)
}
\arguments{
\item{region}{the region name}

\item{spacing}{spacing to be used to create the coverage grid. If
spacing is specified then any value supplied for n.grid.points will
be ignored.}

\item{n.grid.points}{the desired number of grid points (note that
the exact number generated may differ slightly depending on the
shape of the study region).}
}
\value{
object of class Coverage.Grid
}
\description{
This creates an instance of the Coverage.Grid class.
}
\examples{
\donttest{
# This example will take a bit of time to generate
# A coverage grid in a rectangular region of 2000 x 500
region <- make.region()
cover <- make.coverage(region, spacing = 50)
plot(region, cover)
# Create coverage grid by approx number of grid points
cover <- make.coverage(region, n.grid.points = 1000)
plot(region, cover)
}

# Fast running example for CRAN testing purposes
# This spacing is too sparse to assess coverage in a real example
region <- make.region()
cover <- make.coverage(region, spacing = 250)
plot(region, cover)
}
\author{
Laura Marshall
}
