% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comperr_mv.R
\name{dcomperr_mv}
\alias{dcomperr_mv}
\alias{pcomperr_mv}
\alias{rcomperr_mv}
\title{Composed error multivariate distribution}
\usage{
dcomperr_mv(
  x1 = 0,
  mu1 = 0,
  sigma_v1 = 1,
  par_u1 = 1,
  s1 = -1,
  x2 = 0,
  mu2 = 0,
  sigma_v2 = 1,
  par_u2 = 1,
  s2 = -1,
  delta = 0,
  family_mv = c("normhnorm", "normhnorm", "normal"),
  deriv = 0,
  tri = NULL,
  log.p = FALSE,
  check = TRUE
)

pcomperr_mv(
  q1 = 0,
  mu1 = 0,
  sigma_v1 = 1,
  par_u1 = 1,
  s1 = -1,
  q2 = 0,
  mu2 = 0,
  sigma_v2 = 1,
  par_u2 = 1,
  s2 = -1,
  delta = 0,
  family_mv = c("normhnorm", "normhnorm", "normal"),
  log.p = FALSE,
  check = TRUE
)

rcomperr_mv(
  n,
  mu1 = 0,
  sigma_v1 = 1,
  par_u1 = 1,
  s1 = -1,
  mu2 = 0,
  sigma_v2 = 1,
  par_u2 = 1,
  s2 = -1,
  delta = 0,
  family_mv = c("normhnorm", "normhnorm", "normal"),
  check = TRUE
)
}
\arguments{
\item{x1}{vector of quantiles for margin \code{1}.}

\item{mu1}{vector of \eqn{\mu} for margin \code{1}.}

\item{sigma_v1}{vector of \eqn{\sigma_V} for margin 1. Must be positive.}

\item{par_u1}{vector of \eqn{\sigma_U} for margin \code{1}. Must be positive.}

\item{s1}{\eqn{s=-1} for production and \eqn{s=1} for cost function for margin \code{1}.}

\item{x2}{vector of quantiles for margin \code{2}.}

\item{mu2}{vector of \eqn{\mu} for margin \code{2}.}

\item{sigma_v2}{vector of \eqn{\sigma_V} for margin \code{2}. Must be positive.}

\item{par_u2}{vector of \eqn{\sigma_U} for margin \code{2}. Must be positive.}

\item{s2}{\eqn{s=-1} for production and \eqn{s=1} for cost function for margin \code{2}.}

\item{delta}{matrix of copula parameter. Must have at least one column.}

\item{family_mv}{string vector, specifying the the margin one and two, as well as the copula.
For the margins the distributions \code{normhnorm} or \code{normexp} are available. For the family_cop:\cr
\code{independent} = Independence copula \cr
\code{normal} = Gaussian copula \cr
\code{clayton} = Clayton copula \cr
\code{gumbel} = Gumbel copula \cr
\code{frank} = Frank copula \cr
\code{joe} = Joe copula \cr}

\item{deriv}{derivative of order \code{deriv} of the log density. Available are \code{0} and \code{2}.}

\item{tri}{optional, index arrays for upper triangular matrices, generated by \code{\link[mgcv:trind.generator]{trind.generator()}} and supplied to \code{chainrule()}.}

\item{log.p}{logical; if \code{TRUE}, probabilities p are given as \code{log(p)}.}

\item{check}{logical; if TRUE, check inputs.}

\item{q1}{vector of quantiles for margin 1.}

\item{q2}{vector of quantiles for margin 2.}

\item{n}{number of observations.}
}
\value{
\code{dcomperr_mv} gives the density, \code{pcomperr_mv} the distribution and \code{rcomperr_mv} generates random numbers, with given parameters. If the derivatives are calculated these are provided as the attributes \code{gradient}, \code{hessian}, \code{l3} and \code{l4} of the output of the density.
}
\description{
Probablitiy density function, distribution and random number generation for the composed error multivariate distribution.
}
\details{
A bivariate random vector \eqn{(Y_1,Y_2)} follows a composed error multivariate distribution \eqn{f_{Y_1,Y_2}(y_1,y_2)}, which can be rewritten using Sklars' theorem via a copula
\deqn{f_{Y_1,Y_2}(y_1,y_2)=c(F_{Y_1}(y_1),F_{Y_2}(y_2),\delta) \cdot f_{Y_1}(y_1) f_{Y_2}(y_2) \qquad,}
where \eqn{c(\cdot)} is a copula function and \eqn{F_{Y_m}(y_m)},\eqn{f_{Y_m}(y_m)} are the marginal cdf and pdf respectively. \eqn{delta} is the copula parameter.
}
\section{Functions}{
\itemize{
\item \code{pcomperr_mv()}: distribution function for the composed error multivariate distribution.

\item \code{rcomperr_mv()}: random number generation for the composed error multivariate distribution.

}}
\examples{
set.seed(1337)
x2<-10;x1<-5
mu2<-7;mu1<-2
sigma_v2<-6;sigma_v1<-3
par_u2<-3;par_u1<-2
s2<-s1<--1
delta<-matrix(0.5,ncol=1, nrow=100)
family_mv=c("normhnorm","normhnorm","normal")

pdf<-dcomperr_mv(x1, mu1, sigma_v1, par_u1, s1,
                 x2, mu2, sigma_v2, par_u2, s2,
                 delta[1, , drop=FALSE], family_mv, deriv = 2, tri=NULL, log.p=FALSE)

cdf<-pcomperr_mv(q1=x1, mu1, sigma_v1, par_u1, s1,
                 q2=x2, mu2, sigma_v2, par_u2, s2,
                 delta[1, , drop=FALSE], family_mv, log.p=FALSE)
r<-rcomperr_mv(n=100, mu1, sigma_v1, par_u1, s1,
               mu2, sigma_v2, par_u2, s2,
               delta, family_mv)

}
\references{
\itemize{
\item \insertRef{aigner1977formulation}{dsfa}
}
}
