% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsem.R
\name{summary.dsem}
\alias{summary.dsem}
\title{summarize dsem}
\usage{
\method{summary}{dsem}(object, ...)
}
\arguments{
\item{object}{Output from \code{\link{dsem}}}

\item{...}{Not used}
}
\value{
Returns a data.frame summarizing estimated path coefficients, containing columns:
\describe{
\item{path}{The parsed path coefficient}
\item{lag}{The lag, where e.g. 1 means the predictor in time t effects the response in time t+1}
\item{name}{Parameter name}
\item{start}{Start value if supplied, and NA otherwise}
\item{parameter}{Parameter number}
\item{first}{Variable in path treated as predictor}
\item{second}{Variable in path treated as response}
\item{direction}{Whether the path is one-headed or two-headed}
\item{Estimate}{Maximum likelihood estimate}
\item{Std_Error}{Estimated standard error from the Hessian matrix}
\item{z_value}{Estimate divided by Std_Error}
\item{p_value}{P-value associated with z_value using a two-sided Wald test}
}
}
\description{
summarize parameters from a fitted dynamic structural equation model
}
\details{
A DSEM is specified using "arrow and lag" notation, which specifies the set of
path coefficients and exogenous variance parameters to be estimated. Function \code{dsem}
then estimates the maximum likelihood value for those coefficients and parameters
by maximizing the log-marginal likelihood.  Standard errors for parameters are calculated
from the matrix of second derivatives of this log-marginal likelihood (the "Hessian matrix").

However, many users will want to associate individual parameters and standard errors
with the path coefficients that were specified using the "arrow and lag" notation.
This task is complicated in
models where some path coefficients or variance parameters are specified to share a single value a priori,
or were assigned a name of NA and hence assumed to have a fixed value a priori (such that
these coefficients or parameters have an assigned value but no standard error).
The \code{summary} function therefore compiles the MLE for coefficients (including duplicating
values for any path coefficients that assigned the same value) and standard error
estimates, and outputs those in a table that associates them with the user-supplied path and parameter names.
It also outputs the z-score and a p-value arising from a two-sided Wald test (i.e.
comparing the estimate divided by standard error against a standard normal distribution).
}
