% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_multiarm_binary.R
\name{Ess_binary}
\alias{Ess_binary}
\title{Expected sample size for phase III for multiarm programs with binary distributed outcomes}
\usage{
Ess_binary(RRgo, n2, alpha, beta, p0, p11, p12, strategy, case)
}
\arguments{
\item{RRgo}{threshold value for the go/no-go decision rule}

\item{n2}{total sample size for phase II; must be even number}

\item{alpha}{significance level}

\item{beta}{1-beta power for calculation of sample size for phase III}

\item{p0}{assumed true rate of control group}

\item{p11}{assumed true rate of treatment group}

\item{p12}{assumed true rate of treatment group}

\item{strategy}{choose Strategy: 1 ("only best promising"), 2 ("all promising") or 3 (both)}

\item{case}{different cases: 1 ("nogo"), 21 (treatment 1 is promising, treatment 2 is not), 22 (treatment 2 is promising, treatment 1 is not), 31 (both treatments are promising, treatment 1 is better), 32 (both treatments are promising, treatment 2 is better)}
}
\value{
the function Ess_binary() returns the expected sample size for phase III when going to phase III
}
\description{
Given phase II results are promising enough to get the "go"-decision to go to phase III this function now calculates the expected sample size for phase III given the cases and strategies listed below.
The results of this function are necessary for calculating the utility of the program, which is then in a further step maximized by the \code{optimal_multiarm_binary()} function
}
\examples{
res <- Ess_binary(RRgo = 0.8 ,n2 = 50 ,alpha = 0.05, beta = 0.1,
                            p0 = 0.6, p11 =  0.3, p12 = 0.5,strategy = 3, case = 31)
}
\keyword{internal}
